/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.MetricDimension;

@SdkInternalApi
public class MetricDimensionMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MetricDimensionMarshaller INSTANCE = new MetricDimensionMarshaller();

    public static MetricDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricDimension metricDimension, ProtocolMarshaller protocolMarshaller) {
        if (metricDimension == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDimension.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)metricDimension.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

