/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopJarStepConfig;
import software.amazon.awssdk.services.emr.transform.StepConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, StepConfig> {
    private final String name;
    private final String actionOnFailure;
    private final HadoopJarStepConfig hadoopJarStep;

    private StepConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.actionOnFailure = builder.actionOnFailure;
        this.hadoopJarStep = builder.hadoopJarStep;
    }

    public String name() {
        return this.name;
    }

    public ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(this.actionOnFailure);
    }

    public String actionOnFailureString() {
        return this.actionOnFailure;
    }

    public HadoopJarStepConfig hadoopJarStep() {
        return this.hadoopJarStep;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.actionOnFailureString() == null ? 0 : this.actionOnFailureString().hashCode());
        hashCode = 31 * hashCode + (this.hadoopJarStep() == null ? 0 : this.hadoopJarStep().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepConfig)) {
            return false;
        }
        StepConfig other = (StepConfig)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.actionOnFailureString() == null ^ this.actionOnFailureString() == null) {
            return false;
        }
        if (other.actionOnFailureString() != null && !other.actionOnFailureString().equals(this.actionOnFailureString())) {
            return false;
        }
        if (other.hadoopJarStep() == null ^ this.hadoopJarStep() == null) {
            return false;
        }
        return other.hadoopJarStep() == null || other.hadoopJarStep().equals(this.hadoopJarStep());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.actionOnFailureString() != null) {
            sb.append("ActionOnFailure: ").append(this.actionOnFailureString()).append(",");
        }
        if (this.hadoopJarStep() != null) {
            sb.append("HadoopJarStep: ").append(this.hadoopJarStep()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ActionOnFailure": {
                return Optional.of(clazz.cast(this.actionOnFailureString()));
            }
            case "HadoopJarStep": {
                return Optional.of(clazz.cast(this.hadoopJarStep()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String actionOnFailure;
        private HadoopJarStepConfig hadoopJarStep;

        private BuilderImpl() {
        }

        private BuilderImpl(StepConfig model) {
            this.name(model.name);
            this.actionOnFailure(model.actionOnFailure);
            this.hadoopJarStep(model.hadoopJarStep);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getActionOnFailure() {
            return this.actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure.toString());
            return this;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        public final HadoopJarStepConfig.Builder getHadoopJarStep() {
            return this.hadoopJarStep != null ? this.hadoopJarStep.toBuilder() : null;
        }

        @Override
        public final Builder hadoopJarStep(HadoopJarStepConfig hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep;
            return this;
        }

        public final void setHadoopJarStep(HadoopJarStepConfig.BuilderImpl hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep != null ? hadoopJarStep.build() : null;
        }

        public StepConfig build() {
            return new StepConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepConfig> {
        public Builder name(String var1);

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder hadoopJarStep(HadoopJarStepConfig var1);
    }
}

