/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSecurityConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
    private final List<SecurityConfigurationSummary> securityConfigurations;
    private final String marker;

    private ListSecurityConfigurationsResponse(BuilderImpl builder) {
        this.securityConfigurations = builder.securityConfigurations;
        this.marker = builder.marker;
    }

    public List<SecurityConfigurationSummary> securityConfigurations() {
        return this.securityConfigurations;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.securityConfigurations() == null ? 0 : this.securityConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigurationsResponse)) {
            return false;
        }
        ListSecurityConfigurationsResponse other = (ListSecurityConfigurationsResponse)((Object)obj);
        if (other.securityConfigurations() == null ^ this.securityConfigurations() == null) {
            return false;
        }
        if (other.securityConfigurations() != null && !other.securityConfigurations().equals(this.securityConfigurations())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.securityConfigurations() != null) {
            sb.append("SecurityConfigurations: ").append(this.securityConfigurations()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityConfigurations": {
                return Optional.of(clazz.cast(this.securityConfigurations()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<SecurityConfigurationSummary> securityConfigurations;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigurationsResponse model) {
            this.securityConfigurations(model.securityConfigurations);
            this.marker(model.marker);
        }

        public final Collection<SecurityConfigurationSummary.Builder> getSecurityConfigurations() {
            return this.securityConfigurations != null ? (Collection)this.securityConfigurations.stream().map(SecurityConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copy(securityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(SecurityConfigurationSummary ... securityConfigurations) {
            this.securityConfigurations(Arrays.asList(securityConfigurations));
            return this;
        }

        public final void setSecurityConfigurations(Collection<SecurityConfigurationSummary.BuilderImpl> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copyFromBuilder(securityConfigurations);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListSecurityConfigurationsResponse build() {
            return new ListSecurityConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
        public Builder securityConfigurations(Collection<SecurityConfigurationSummary> var1);

        public Builder securityConfigurations(SecurityConfigurationSummary ... var1);

        public Builder marker(String var1);
    }
}

