/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleetState;
import software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceFleetTimeline;
import software.amazon.awssdk.services.emr.transform.InstanceFleetStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceFleetStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleetStatus> {
    private final String state;
    private final InstanceFleetStateChangeReason stateChangeReason;
    private final InstanceFleetTimeline timeline;

    private InstanceFleetStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public InstanceFleetState state() {
        return InstanceFleetState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public InstanceFleetStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public InstanceFleetTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.timeline() == null ? 0 : this.timeline().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetStatus)) {
            return false;
        }
        InstanceFleetStatus other = (InstanceFleetStatus)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.timeline() == null ^ this.timeline() == null) {
            return false;
        }
        return other.timeline() == null || other.timeline().equals(this.timeline());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.timeline() != null) {
            sb.append("Timeline: ").append(this.timeline()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.of(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceFleetStateChangeReason stateChangeReason;
        private InstanceFleetTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceFleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceFleetStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceFleetStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceFleetStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final InstanceFleetTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(InstanceFleetTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceFleetTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public InstanceFleetStatus build() {
            return new InstanceFleetStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleetStatus> {
        public Builder state(String var1);

        public Builder state(InstanceFleetState var1);

        public Builder stateChangeReason(InstanceFleetStateChangeReason var1);

        public Builder timeline(InstanceFleetTimeline var1);
    }
}

