/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.JobFlowDetail;
import software.amazon.awssdk.services.emr.model.JobFlowDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobFlowsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobFlowsResponse> {
    private final List<JobFlowDetail> jobFlows;

    private DescribeJobFlowsResponse(BuilderImpl builder) {
        this.jobFlows = builder.jobFlows;
    }

    public List<JobFlowDetail> jobFlows() {
        return this.jobFlows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobFlows() == null ? 0 : this.jobFlows().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsResponse)) {
            return false;
        }
        DescribeJobFlowsResponse other = (DescribeJobFlowsResponse)((Object)obj);
        if (other.jobFlows() == null ^ this.jobFlows() == null) {
            return false;
        }
        return other.jobFlows() == null || other.jobFlows().equals(this.jobFlows());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobFlows() != null) {
            sb.append("JobFlows: ").append(this.jobFlows()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlows": {
                return Optional.of(clazz.cast(this.jobFlows()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<JobFlowDetail> jobFlows;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsResponse model) {
            this.jobFlows(model.jobFlows);
        }

        public final Collection<JobFlowDetail.Builder> getJobFlows() {
            return this.jobFlows != null ? (Collection)this.jobFlows.stream().map(JobFlowDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobFlows(Collection<JobFlowDetail> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copy(jobFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlows(JobFlowDetail ... jobFlows) {
            this.jobFlows(Arrays.asList(jobFlows));
            return this;
        }

        public final void setJobFlows(Collection<JobFlowDetail.BuilderImpl> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copyFromBuilder(jobFlows);
        }

        public DescribeJobFlowsResponse build() {
            return new DescribeJobFlowsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobFlowsResponse> {
        public Builder jobFlows(Collection<JobFlowDetail> var1);

        public Builder jobFlows(JobFlowDetail ... var1);
    }
}

