/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionState;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobFlowsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeJobFlowsRequest> {
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> jobFlowIds;
    private final List<String> jobFlowStates;

    private DescribeJobFlowsRequest(BuilderImpl builder) {
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.jobFlowIds = builder.jobFlowIds;
        this.jobFlowStates = builder.jobFlowStates;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public List<JobFlowExecutionState> jobFlowStates() {
        return TypeConverter.convert(this.jobFlowStates, JobFlowExecutionState::fromValue);
    }

    public List<String> jobFlowStatesStrings() {
        return this.jobFlowStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createdAfter() == null ? 0 : this.createdAfter().hashCode());
        hashCode = 31 * hashCode + (this.createdBefore() == null ? 0 : this.createdBefore().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowIds() == null ? 0 : this.jobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowStatesStrings() == null ? 0 : this.jobFlowStatesStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsRequest)) {
            return false;
        }
        DescribeJobFlowsRequest other = (DescribeJobFlowsRequest)((Object)obj);
        if (other.createdAfter() == null ^ this.createdAfter() == null) {
            return false;
        }
        if (other.createdAfter() != null && !other.createdAfter().equals(this.createdAfter())) {
            return false;
        }
        if (other.createdBefore() == null ^ this.createdBefore() == null) {
            return false;
        }
        if (other.createdBefore() != null && !other.createdBefore().equals(this.createdBefore())) {
            return false;
        }
        if (other.jobFlowIds() == null ^ this.jobFlowIds() == null) {
            return false;
        }
        if (other.jobFlowIds() != null && !other.jobFlowIds().equals(this.jobFlowIds())) {
            return false;
        }
        if (other.jobFlowStatesStrings() == null ^ this.jobFlowStatesStrings() == null) {
            return false;
        }
        return other.jobFlowStatesStrings() == null || other.jobFlowStatesStrings().equals(this.jobFlowStatesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.createdAfter() != null) {
            sb.append("CreatedAfter: ").append(this.createdAfter()).append(",");
        }
        if (this.createdBefore() != null) {
            sb.append("CreatedBefore: ").append(this.createdBefore()).append(",");
        }
        if (this.jobFlowIds() != null) {
            sb.append("JobFlowIds: ").append(this.jobFlowIds()).append(",");
        }
        if (this.jobFlowStatesStrings() != null) {
            sb.append("JobFlowStates: ").append(this.jobFlowStatesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAfter": {
                return Optional.of(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.of(clazz.cast(this.createdBefore()));
            }
            case "JobFlowIds": {
                return Optional.of(clazz.cast(this.jobFlowIds()));
            }
            case "JobFlowStates": {
                return Optional.of(clazz.cast(this.jobFlowStatesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> jobFlowIds;
        private List<String> jobFlowStates;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsRequest model) {
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.jobFlowIds(model.jobFlowIds);
            this.jobFlowStates(model.jobFlowStates);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        public final Collection<String> getJobFlowStates() {
            return this.jobFlowStates;
        }

        @Override
        public final Builder jobFlowStates(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowStates(String ... jobFlowStates) {
            this.jobFlowStates(Arrays.asList(jobFlowStates));
            return this;
        }

        public final void setJobFlowStates(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
        }

        public DescribeJobFlowsRequest build() {
            return new DescribeJobFlowsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobFlowsRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder jobFlowStates(Collection<String> var1);

        public Builder jobFlowStates(String ... var1);
    }
}

