/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ClusterStatus;
import software.amazon.awssdk.services.emr.transform.ClusterSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterSummary> {
    private final String id;
    private final String name;
    private final ClusterStatus status;
    private final Integer normalizedInstanceHours;

    private ClusterSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ClusterStatus status() {
        return this.status;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.normalizedInstanceHours() == null ? 0 : this.normalizedInstanceHours().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSummary)) {
            return false;
        }
        ClusterSummary other = (ClusterSummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.normalizedInstanceHours() == null ^ this.normalizedInstanceHours() == null) {
            return false;
        }
        return other.normalizedInstanceHours() == null || other.normalizedInstanceHours().equals(this.normalizedInstanceHours());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.normalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: ").append(this.normalizedInstanceHours()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "NormalizedInstanceHours": {
                return Optional.of(clazz.cast(this.normalizedInstanceHours()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ClusterStatus status;
        private Integer normalizedInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.normalizedInstanceHours(model.normalizedInstanceHours);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ClusterStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClusterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public ClusterSummary build() {
            return new ClusterSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(ClusterStatus var1);

        public Builder normalizedInstanceHours(Integer var1);
    }
}

