/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.InstanceGroupIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddInstanceGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AddInstanceGroupsResponse> {
    private final String jobFlowId;
    private final List<String> instanceGroupIds;

    private AddInstanceGroupsResponse(BuilderImpl builder) {
        this.jobFlowId = builder.jobFlowId;
        this.instanceGroupIds = builder.instanceGroupIds;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public List<String> instanceGroupIds() {
        return this.instanceGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobFlowId() == null ? 0 : this.jobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroupIds() == null ? 0 : this.instanceGroupIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsResponse)) {
            return false;
        }
        AddInstanceGroupsResponse other = (AddInstanceGroupsResponse)((Object)obj);
        if (other.jobFlowId() == null ^ this.jobFlowId() == null) {
            return false;
        }
        if (other.jobFlowId() != null && !other.jobFlowId().equals(this.jobFlowId())) {
            return false;
        }
        if (other.instanceGroupIds() == null ^ this.instanceGroupIds() == null) {
            return false;
        }
        return other.instanceGroupIds() == null || other.instanceGroupIds().equals(this.instanceGroupIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        if (this.instanceGroupIds() != null) {
            sb.append("InstanceGroupIds: ").append(this.instanceGroupIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowId": {
                return Optional.of(clazz.cast(this.jobFlowId()));
            }
            case "InstanceGroupIds": {
                return Optional.of(clazz.cast(this.instanceGroupIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobFlowId;
        private List<String> instanceGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsResponse model) {
            this.jobFlowId(model.jobFlowId);
            this.instanceGroupIds(model.instanceGroupIds);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<String> getInstanceGroupIds() {
            return this.instanceGroupIds;
        }

        @Override
        public final Builder instanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupIds(String ... instanceGroupIds) {
            this.instanceGroupIds(Arrays.asList(instanceGroupIds));
            return this;
        }

        public final void setInstanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
        }

        public AddInstanceGroupsResponse build() {
            return new AddInstanceGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddInstanceGroupsResponse> {
        public Builder jobFlowId(String var1);

        public Builder instanceGroupIds(Collection<String> var1);

        public Builder instanceGroupIds(String ... var1);
    }
}

