/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleet;

@SdkInternalApi
public class InstanceFleetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> INSTANCEFLEETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetType").build();
    private static final MarshallingInfo<Integer> TARGETONDEMANDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetOnDemandCapacity").build();
    private static final MarshallingInfo<Integer> TARGETSPOTCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetSpotCapacity").build();
    private static final MarshallingInfo<Integer> PROVISIONEDONDEMANDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedOnDemandCapacity").build();
    private static final MarshallingInfo<Integer> PROVISIONEDSPOTCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedSpotCapacity").build();
    private static final MarshallingInfo<List> INSTANCETYPESPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceTypeSpecifications").build();
    private static final MarshallingInfo<StructuredPojo> LAUNCHSPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchSpecifications").build();
    private static final InstanceFleetMarshaller INSTANCE = new InstanceFleetMarshaller();

    public static InstanceFleetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceFleet instanceFleet, ProtocolMarshaller protocolMarshaller) {
        if (instanceFleet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceFleet.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.instanceFleetType(), INSTANCEFLEETTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.targetOnDemandCapacity(), TARGETONDEMANDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.targetSpotCapacity(), TARGETSPOTCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.provisionedOnDemandCapacity(), PROVISIONEDONDEMANDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.provisionedSpotCapacity(), PROVISIONEDSPOTCAPACITY_BINDING);
            protocolMarshaller.marshall(instanceFleet.instanceTypeSpecifications(), INSTANCETYPESPECIFICATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.launchSpecifications(), LAUNCHSPECIFICATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

