/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.VolumeSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, VolumeSpecification> {
    private final String volumeType;
    private final Integer iops;
    private final Integer sizeInGB;

    private VolumeSpecification(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.sizeInGB = builder.sizeInGB;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeType() == null ? 0 : this.volumeType().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.sizeInGB() == null ? 0 : this.sizeInGB().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeSpecification)) {
            return false;
        }
        VolumeSpecification other = (VolumeSpecification)obj;
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.sizeInGB() == null ^ this.sizeInGB() == null) {
            return false;
        }
        return other.sizeInGB() == null || other.sizeInGB().equals(this.sizeInGB());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeType() != null) {
            sb.append("VolumeType: ").append(this.volumeType()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.sizeInGB() != null) {
            sb.append("SizeInGB: ").append(this.sizeInGB()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String volumeType;
        private Integer iops;
        private Integer sizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeSpecification model) {
            this.setVolumeType(model.volumeType);
            this.setIops(model.iops);
            this.setSizeInGB(model.sizeInGB);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Integer getSizeInGB() {
            return this.sizeInGB;
        }

        @Override
        public final Builder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public final void setSizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        public VolumeSpecification build() {
            return new VolumeSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeSpecification> {
        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder sizeInGB(Integer var1);
    }
}

