/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.util;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfig;
import software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig;
import software.amazon.awssdk.util.StringUtils;

@ReviewBeforeRelease(value="This and the other classes in this package - delete or clean up.")
public class BootstrapActions {
    private final String bucket;

    public BootstrapActions() {
        this("us-east-1.elasticmapreduce");
    }

    public BootstrapActions(String bucket) {
        this.bucket = bucket;
    }

    public BootstrapActionConfig newRunIf(String condition, BootstrapActionConfig config) {
        List<String> args = config.scriptBootstrapAction().args();
        args.add(0, condition);
        args.add(1, config.scriptBootstrapAction().path());
        return (BootstrapActionConfig)BootstrapActionConfig.builder().name("Run If, " + config.name()).scriptBootstrapAction((ScriptBootstrapActionConfig)ScriptBootstrapActionConfig.builder().path("s3://" + this.bucket + "/bootstrap-actions/run-if").args(args).build()).build();
    }

    public ConfigureHadoop newConfigureHadoop() {
        return new ConfigureHadoop();
    }

    public ConfigureDaemons newConfigureDaemons() {
        return new ConfigureDaemons();
    }

    public class ConfigureDaemons {
        List<String> args = new ArrayList<String>();
        boolean replace = false;

        private ConfigureDaemons() {
        }

        public ConfigureDaemons withHeapSize(Daemon daemon, int megabytes) {
            this.args.add("--" + StringUtils.lowerCase((String)daemon.name()) + "-heap-size=" + megabytes);
            return this;
        }

        public ConfigureDaemons withOpts(Daemon daemon, String opts) {
            this.args.add("--" + StringUtils.lowerCase((String)daemon.name()) + "-opts=\"" + opts + "\"");
            return this;
        }

        public ConfigureDaemons withReplace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public BootstrapActionConfig build() {
            if (this.replace) {
                this.args.add("--replace");
            }
            return (BootstrapActionConfig)BootstrapActionConfig.builder().name("Configure Daemons").scriptBootstrapAction((ScriptBootstrapActionConfig)ScriptBootstrapActionConfig.builder().path("s3://" + BootstrapActions.this.bucket + "/bootstrap-actions/configure-daemons").args(this.args).build()).build();
        }
    }

    @Deprecated
    public class ConfigureHadoop {
        List<String> args = new ArrayList<String>();

        private ConfigureHadoop() {
        }

        public ConfigureHadoop withXml(ConfigFile file, String xmlPath) {
            String arg;
            switch (file) {
                case Site: {
                    arg = "-S";
                    break;
                }
                case Default: {
                    arg = "-D";
                    break;
                }
                case Core: {
                    arg = "-C";
                    break;
                }
                case Hdfs: {
                    arg = "-H";
                    break;
                }
                case Mapred: {
                    arg = "-M";
                    break;
                }
                default: {
                    arg = "";
                }
            }
            this.args.add(arg);
            this.args.add(xmlPath);
            return this;
        }

        public ConfigureHadoop withKeyValue(ConfigFile file, String key, String value) {
            String arg;
            switch (file) {
                case Site: {
                    arg = "-s";
                    break;
                }
                case Default: {
                    arg = "-d";
                    break;
                }
                case Core: {
                    arg = "-c";
                    break;
                }
                case Hdfs: {
                    arg = "-h";
                    break;
                }
                case Mapred: {
                    arg = "-m";
                    break;
                }
                default: {
                    arg = "";
                }
            }
            this.args.add(arg);
            this.args.add(key + "=" + value);
            return this;
        }

        public BootstrapActionConfig build() {
            return (BootstrapActionConfig)BootstrapActionConfig.builder().name("Configure Hadoop").scriptBootstrapAction((ScriptBootstrapActionConfig)ScriptBootstrapActionConfig.builder().path("s3://" + BootstrapActions.this.bucket + "/bootstrap-actions/configure-hadoop").args(this.args).build()).build();
        }
    }

    public static enum Daemon {
        NameNode,
        DataNode,
        JobTracker,
        TaskTracker,
        Client;

    }

    public static enum ConfigFile {
        Site,
        Default,
        Core,
        Hdfs,
        Mapred;

    }
}

