/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.services.emr.transform.EbsVolumeUnmarshaller;
import software.amazon.awssdk.services.emr.transform.InstanceStatusUnmarshaller;

public class InstanceUnmarshaller
implements Unmarshaller<Instance, JsonUnmarshallerContext> {
    private static final InstanceUnmarshaller INSTANCE = new InstanceUnmarshaller();

    public Instance unmarshall(JsonUnmarshallerContext context) throws Exception {
        Instance.Builder instanceBuilder = Instance.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Ec2InstanceId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ec2InstanceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicDnsName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicDnsName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrivateDnsName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateDnsName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrivateIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.status(InstanceStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InstanceGroupId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceGroupId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceFleetId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceFleetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Market", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.market((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EbsVolumes", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ebsVolumes(new ListUnmarshaller((Unmarshaller)EbsVolumeUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Instance)instanceBuilder.build();
    }

    public static InstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

