/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.services.emr.transform.ConfigurationUnmarshaller;
import software.amazon.awssdk.services.emr.transform.EbsConfigurationUnmarshaller;

public class InstanceTypeConfigUnmarshaller
implements Unmarshaller<InstanceTypeConfig, JsonUnmarshallerContext> {
    private static final InstanceTypeConfigUnmarshaller INSTANCE = new InstanceTypeConfigUnmarshaller();

    public InstanceTypeConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceTypeConfig.Builder instanceTypeConfigBuilder = InstanceTypeConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("WeightedCapacity", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.weightedCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("BidPrice", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.bidPrice((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BidPriceAsPercentageOfOnDemandPrice", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.bidPriceAsPercentageOfOnDemandPrice((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("EbsConfiguration", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.ebsConfiguration(EbsConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    instanceTypeConfigBuilder.configurations(new ListUnmarshaller((Unmarshaller)ConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceTypeConfig)instanceTypeConfigBuilder.build();
    }

    public static InstanceTypeConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

