/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;
import software.amazon.awssdk.services.emr.model.StepStatus;
import software.amazon.awssdk.services.emr.transform.StepSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StepSummary> {
    private final String id;
    private final String name;
    private final HadoopStepConfig config;
    private final String actionOnFailure;
    private final StepStatus status;

    private StepSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
        this.actionOnFailure = builder.actionOnFailure;
        this.status = builder.status;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public HadoopStepConfig config() {
        return this.config;
    }

    public String actionOnFailure() {
        return this.actionOnFailure;
    }

    public StepStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.config() == null ? 0 : this.config().hashCode());
        hashCode = 31 * hashCode + (this.actionOnFailure() == null ? 0 : this.actionOnFailure().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSummary)) {
            return false;
        }
        StepSummary other = (StepSummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.config() == null ^ this.config() == null) {
            return false;
        }
        if (other.config() != null && !other.config().equals(this.config())) {
            return false;
        }
        if (other.actionOnFailure() == null ^ this.actionOnFailure() == null) {
            return false;
        }
        if (other.actionOnFailure() != null && !other.actionOnFailure().equals(this.actionOnFailure())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.config() != null) {
            sb.append("Config: ").append(this.config()).append(",");
        }
        if (this.actionOnFailure() != null) {
            sb.append("ActionOnFailure: ").append(this.actionOnFailure()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private HadoopStepConfig config;
        private String actionOnFailure;
        private StepStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSummary model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setConfig(model.config);
            this.setActionOnFailure(model.actionOnFailure);
            this.setStatus(model.status);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final HadoopStepConfig getConfig() {
            return this.config;
        }

        @Override
        public final Builder config(HadoopStepConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HadoopStepConfig config) {
            this.config = config;
        }

        public final String getActionOnFailure() {
            return this.actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure.toString());
            return this;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        public final StepStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(StepStatus status) {
            this.status = status;
        }

        public StepSummary build() {
            return new StepSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder config(HadoopStepConfig var1);

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder status(StepStatus var1);
    }
}

