/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceResizePolicy;
import software.amazon.awssdk.services.emr.transform.ShrinkPolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShrinkPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ShrinkPolicy> {
    private final Integer decommissionTimeout;
    private final InstanceResizePolicy instanceResizePolicy;

    private ShrinkPolicy(BuilderImpl builder) {
        this.decommissionTimeout = builder.decommissionTimeout;
        this.instanceResizePolicy = builder.instanceResizePolicy;
    }

    public Integer decommissionTimeout() {
        return this.decommissionTimeout;
    }

    public InstanceResizePolicy instanceResizePolicy() {
        return this.instanceResizePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.decommissionTimeout() == null ? 0 : this.decommissionTimeout().hashCode());
        hashCode = 31 * hashCode + (this.instanceResizePolicy() == null ? 0 : this.instanceResizePolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShrinkPolicy)) {
            return false;
        }
        ShrinkPolicy other = (ShrinkPolicy)obj;
        if (other.decommissionTimeout() == null ^ this.decommissionTimeout() == null) {
            return false;
        }
        if (other.decommissionTimeout() != null && !other.decommissionTimeout().equals(this.decommissionTimeout())) {
            return false;
        }
        if (other.instanceResizePolicy() == null ^ this.instanceResizePolicy() == null) {
            return false;
        }
        return other.instanceResizePolicy() == null || other.instanceResizePolicy().equals(this.instanceResizePolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.decommissionTimeout() != null) {
            sb.append("DecommissionTimeout: ").append(this.decommissionTimeout()).append(",");
        }
        if (this.instanceResizePolicy() != null) {
            sb.append("InstanceResizePolicy: ").append(this.instanceResizePolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShrinkPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer decommissionTimeout;
        private InstanceResizePolicy instanceResizePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ShrinkPolicy model) {
            this.setDecommissionTimeout(model.decommissionTimeout);
            this.setInstanceResizePolicy(model.instanceResizePolicy);
        }

        public final Integer getDecommissionTimeout() {
            return this.decommissionTimeout;
        }

        @Override
        public final Builder decommissionTimeout(Integer decommissionTimeout) {
            this.decommissionTimeout = decommissionTimeout;
            return this;
        }

        public final void setDecommissionTimeout(Integer decommissionTimeout) {
            this.decommissionTimeout = decommissionTimeout;
        }

        public final InstanceResizePolicy getInstanceResizePolicy() {
            return this.instanceResizePolicy;
        }

        @Override
        public final Builder instanceResizePolicy(InstanceResizePolicy instanceResizePolicy) {
            this.instanceResizePolicy = instanceResizePolicy;
            return this;
        }

        public final void setInstanceResizePolicy(InstanceResizePolicy instanceResizePolicy) {
            this.instanceResizePolicy = instanceResizePolicy;
        }

        public ShrinkPolicy build() {
            return new ShrinkPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShrinkPolicy> {
        public Builder decommissionTimeout(Integer var1);

        public Builder instanceResizePolicy(InstanceResizePolicy var1);
    }
}

