/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfigListCopier;
import software.amazon.awssdk.services.emr.transform.EbsConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsConfiguration> {
    private final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;
    private final Boolean ebsOptimized;

    private EbsConfiguration(BuilderImpl builder) {
        this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
        this.ebsOptimized = builder.ebsOptimized;
    }

    public List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs() {
        return this.ebsBlockDeviceConfigs;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ebsBlockDeviceConfigs() == null ? 0 : this.ebsBlockDeviceConfigs().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsConfiguration)) {
            return false;
        }
        EbsConfiguration other = (EbsConfiguration)obj;
        if (other.ebsBlockDeviceConfigs() == null ^ this.ebsBlockDeviceConfigs() == null) {
            return false;
        }
        if (other.ebsBlockDeviceConfigs() != null && !other.ebsBlockDeviceConfigs().equals(this.ebsBlockDeviceConfigs())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        return other.ebsOptimized() == null || other.ebsOptimized().equals(this.ebsOptimized());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ebsBlockDeviceConfigs() != null) {
            sb.append("EbsBlockDeviceConfigs: ").append(this.ebsBlockDeviceConfigs()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;
        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsConfiguration model) {
            this.setEbsBlockDeviceConfigs(model.ebsBlockDeviceConfigs);
            this.setEbsOptimized(model.ebsOptimized);
        }

        public final Collection<EbsBlockDeviceConfig> getEbsBlockDeviceConfigs() {
            return this.ebsBlockDeviceConfigs;
        }

        @Override
        public final Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copy(ebsBlockDeviceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig ... ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs(Arrays.asList(ebsBlockDeviceConfigs));
            return this;
        }

        public final void setEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copy(ebsBlockDeviceConfigs);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public EbsConfiguration build() {
            return new EbsConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsConfiguration> {
        public Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> var1);

        public Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig ... var1);

        public Builder ebsOptimized(Boolean var1);
    }
}

