/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus;
import software.amazon.awssdk.services.emr.transform.CancelStepsInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelStepsInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, CancelStepsInfo> {
    private final String stepId;
    private final String status;
    private final String reason;

    private CancelStepsInfo(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    public String stepId() {
        return this.stepId;
    }

    public String status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stepId() == null ? 0 : this.stepId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.reason() == null ? 0 : this.reason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsInfo)) {
            return false;
        }
        CancelStepsInfo other = (CancelStepsInfo)obj;
        if (other.stepId() == null ^ this.stepId() == null) {
            return false;
        }
        if (other.stepId() != null && !other.stepId().equals(this.stepId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        return other.reason() == null || other.reason().equals(this.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stepId() != null) {
            sb.append("StepId: ").append(this.stepId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CancelStepsInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String status;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsInfo model) {
            this.setStepId(model.stepId);
            this.setStatus(model.status);
            this.setReason(model.reason);
        }

        public final String getStepId() {
            return this.stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CancelStepsRequestStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public CancelStepsInfo build() {
            return new CancelStepsInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelStepsInfo> {
        public Builder stepId(String var1);

        public Builder status(String var1);

        public Builder status(CancelStepsRequestStatus var1);

        public Builder reason(String var1);
    }
}

