/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.SdkRequest;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.config.ClientConfiguration;
import software.amazon.awssdk.config.SyncClientConfiguration;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse;
import software.amazon.awssdk.services.emr.model.AddTagsRequest;
import software.amazon.awssdk.services.emr.model.AddTagsResponse;
import software.amazon.awssdk.services.emr.model.CancelStepsRequest;
import software.amazon.awssdk.services.emr.model.CancelStepsResponse;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeJobFlowsRequest;
import software.amazon.awssdk.services.emr.model.DescribeJobFlowsResponse;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.model.EMRException;
import software.amazon.awssdk.services.emr.model.InternalServerErrorException;
import software.amazon.awssdk.services.emr.model.InternalServerException;
import software.amazon.awssdk.services.emr.model.InvalidRequestException;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveTagsRequest;
import software.amazon.awssdk.services.emr.model.RemoveTagsResponse;
import software.amazon.awssdk.services.emr.model.RunJobFlowRequest;
import software.amazon.awssdk.services.emr.model.RunJobFlowResponse;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionResponse;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersResponse;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsResponse;
import software.amazon.awssdk.services.emr.transform.AddInstanceFleetRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.AddInstanceFleetResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.AddInstanceGroupsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.AddInstanceGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.AddJobFlowStepsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.AddJobFlowStepsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.CancelStepsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.CancelStepsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.CreateSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.CreateSecurityConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.DeleteSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.DeleteSecurityConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeClusterResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeJobFlowsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeJobFlowsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeSecurityConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeStepRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.DescribeStepResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListBootstrapActionsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListBootstrapActionsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListClustersResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstanceFleetsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstanceFleetsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstanceGroupsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstanceGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListSecurityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListSecurityConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ListStepsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ListStepsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ModifyInstanceFleetRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ModifyInstanceFleetResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ModifyInstanceGroupsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.ModifyInstanceGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.PutAutoScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.PutAutoScalingPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.RemoveAutoScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.RemoveAutoScalingPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.RemoveTagsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.RunJobFlowRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.RunJobFlowResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.SetTerminationProtectionRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.SetTerminationProtectionResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.SetVisibleToAllUsersRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.SetVisibleToAllUsersResponseUnmarshaller;
import software.amazon.awssdk.services.emr.transform.TerminateJobFlowsRequestMarshaller;
import software.amazon.awssdk.services.emr.transform.TerminateJobFlowsResponseUnmarshaller;
import software.amazon.awssdk.services.emr.waiters.EMRClientWaiters;

@SdkInternalApi
final class DefaultEMRClient
implements EMRClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;
    private volatile EMRClientWaiters waiters;

    protected DefaultEMRClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AddInstanceFleetResponse addInstanceFleet(AddInstanceFleetRequest addInstanceFleetRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddInstanceFleetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddInstanceFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addInstanceFleetRequest).withMarshaller((Marshaller)new AddInstanceFleetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddInstanceGroupsResponse addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddInstanceGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddInstanceGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addInstanceGroupsRequest).withMarshaller((Marshaller)new AddInstanceGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddJobFlowStepsResponse addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddJobFlowStepsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddJobFlowStepsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addJobFlowStepsRequest).withMarshaller((Marshaller)new AddJobFlowStepsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CancelStepsResponse cancelSteps(CancelStepsRequest cancelStepsRequest) throws InternalServerErrorException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelStepsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelStepsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelStepsRequest).withMarshaller((Marshaller)new CancelStepsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSecurityConfigurationResponse createSecurityConfiguration(CreateSecurityConfigurationRequest createSecurityConfigurationRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSecurityConfigurationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateSecurityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSecurityConfigurationRequest).withMarshaller((Marshaller)new CreateSecurityConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSecurityConfigurationResponse deleteSecurityConfiguration(DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSecurityConfigurationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteSecurityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSecurityConfigurationRequest).withMarshaller((Marshaller)new DeleteSecurityConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterRequest).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobFlowsResponse describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobFlowsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeJobFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobFlowsRequest).withMarshaller((Marshaller)new DescribeJobFlowsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSecurityConfigurationResponse describeSecurityConfiguration(DescribeSecurityConfigurationRequest describeSecurityConfigurationRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSecurityConfigurationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeSecurityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSecurityConfigurationRequest).withMarshaller((Marshaller)new DescribeSecurityConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStepResponse describeStep(DescribeStepRequest describeStepRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStepResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeStepResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStepRequest).withMarshaller((Marshaller)new DescribeStepRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListBootstrapActionsResponse listBootstrapActions(ListBootstrapActionsRequest listBootstrapActionsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBootstrapActionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListBootstrapActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBootstrapActionsRequest).withMarshaller((Marshaller)new ListBootstrapActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClustersRequest).withMarshaller((Marshaller)new ListClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInstanceFleetsResponse listInstanceFleets(ListInstanceFleetsRequest listInstanceFleetsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstanceFleetsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListInstanceFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInstanceFleetsRequest).withMarshaller((Marshaller)new ListInstanceFleetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInstanceGroupsResponse listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstanceGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListInstanceGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInstanceGroupsRequest).withMarshaller((Marshaller)new ListInstanceGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstancesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInstancesRequest).withMarshaller((Marshaller)new ListInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListSecurityConfigurationsResponse listSecurityConfigurations(ListSecurityConfigurationsRequest listSecurityConfigurationsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSecurityConfigurationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListSecurityConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSecurityConfigurationsRequest).withMarshaller((Marshaller)new ListSecurityConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStepsResponse listSteps(ListStepsRequest listStepsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStepsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListStepsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStepsRequest).withMarshaller((Marshaller)new ListStepsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyInstanceFleetResponse modifyInstanceFleet(ModifyInstanceFleetRequest modifyInstanceFleetRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyInstanceFleetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyInstanceFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyInstanceFleetRequest).withMarshaller((Marshaller)new ModifyInstanceFleetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyInstanceGroupsResponse modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyInstanceGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyInstanceGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyInstanceGroupsRequest).withMarshaller((Marshaller)new ModifyInstanceGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutAutoScalingPolicyResponse putAutoScalingPolicy(PutAutoScalingPolicyRequest putAutoScalingPolicyRequest) throws SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAutoScalingPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutAutoScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAutoScalingPolicyRequest).withMarshaller((Marshaller)new PutAutoScalingPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveAutoScalingPolicyResponse removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest removeAutoScalingPolicyRequest) throws SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAutoScalingPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveAutoScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAutoScalingPolicyRequest).withMarshaller((Marshaller)new RemoveAutoScalingPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws InternalServerException, InvalidRequestException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RunJobFlowResponse runJobFlow(RunJobFlowRequest runJobFlowRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RunJobFlowResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RunJobFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)runJobFlowRequest).withMarshaller((Marshaller)new RunJobFlowRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetTerminationProtectionResponse setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetTerminationProtectionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetTerminationProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTerminationProtectionRequest).withMarshaller((Marshaller)new SetTerminationProtectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetVisibleToAllUsersResponse setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetVisibleToAllUsersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetVisibleToAllUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setVisibleToAllUsersRequest).withMarshaller((Marshaller)new SetVisibleToAllUsersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TerminateJobFlowsResponse terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) throws InternalServerErrorException, SdkBaseException, SdkClientException, EMRException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TerminateJobFlowsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TerminateJobFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateJobFlowsRequest).withMarshaller((Marshaller)new TerminateJobFlowsRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(EMRException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EMRClientWaiters waiters() {
        if (this.waiters == null) {
            DefaultEMRClient defaultEMRClient = this;
            synchronized (defaultEMRClient) {
                if (this.waiters == null) {
                    this.waiters = new EMRClientWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    public void close() {
        this.clientHandler.close();
    }
}

