/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.ScalingRule;
import software.amazon.awssdk.services.emr.transform.ScalingActionUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ScalingTriggerUnmarshaller;

public class ScalingRuleUnmarshaller
implements Unmarshaller<ScalingRule, JsonUnmarshallerContext> {
    private static ScalingRuleUnmarshaller INSTANCE;

    public ScalingRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        ScalingRule.Builder scalingRuleBuilder = ScalingRule.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    scalingRuleBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    scalingRuleBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    scalingRuleBuilder.action(ScalingActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Trigger", targetDepth)) {
                    context.nextToken();
                    scalingRuleBuilder.trigger(ScalingTriggerUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ScalingRule)scalingRuleBuilder.build();
    }

    public static ScalingRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScalingRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

