/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.InstanceGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstanceGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInstanceGroupsResponse> {
    private final List<InstanceGroup> instanceGroups;
    private final String marker;

    private ListInstanceGroupsResponse(BuilderImpl builder) {
        this.instanceGroups = builder.instanceGroups;
        this.marker = builder.marker;
    }

    public List<InstanceGroup> instanceGroups() {
        return this.instanceGroups;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceGroups() == null ? 0 : this.instanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceGroupsResponse)) {
            return false;
        }
        ListInstanceGroupsResponse other = (ListInstanceGroupsResponse)((Object)obj);
        if (other.instanceGroups() == null ^ this.instanceGroups() == null) {
            return false;
        }
        if (other.instanceGroups() != null && !other.instanceGroups().equals(this.instanceGroups())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceGroup> instanceGroups;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceGroupsResponse model) {
            this.setInstanceGroups(model.instanceGroups);
            this.setMarker(model.marker);
        }

        public final Collection<InstanceGroup> getInstanceGroups() {
            return this.instanceGroups;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroup> instanceGroups) {
            this.instanceGroups = InstanceGroupListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroup ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroup> instanceGroups) {
            this.instanceGroups = InstanceGroupListCopier.copy(instanceGroups);
        }

        @SafeVarargs
        public final void setInstanceGroups(InstanceGroup ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstanceGroupsResponse build() {
            return new ListInstanceGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstanceGroupsResponse> {
        public Builder instanceGroups(Collection<InstanceGroup> var1);

        public Builder instanceGroups(InstanceGroup ... var1);

        public Builder marker(String var1);
    }
}

