/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceFleetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstanceFleetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInstanceFleetsResponse> {
    private final List<InstanceFleet> instanceFleets;
    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    public List<InstanceFleet> instanceFleets() {
        return this.instanceFleets;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceFleets() == null ? 0 : this.instanceFleets().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse)((Object)obj);
        if (other.instanceFleets() == null ^ this.instanceFleets() == null) {
            return false;
        }
        if (other.instanceFleets() != null && !other.instanceFleets().equals(this.instanceFleets())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceFleets() != null) {
            sb.append("InstanceFleets: ").append(this.instanceFleets()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceFleet> instanceFleets;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            this.setInstanceFleets(model.instanceFleets);
            this.setMarker(model.marker);
        }

        public final Collection<InstanceFleet> getInstanceFleets() {
            return this.instanceFleets;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
        }

        @SafeVarargs
        public final void setInstanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        public Builder instanceFleets(Collection<InstanceFleet> var1);

        public Builder instanceFleets(InstanceFleet ... var1);

        public Builder marker(String var1);
    }
}

