/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepExecutionStatusDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepDetail> {
    private static final SdkField<StepConfig> STEP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StepDetail.getter(StepDetail::stepConfig)).setter(StepDetail.setter(Builder::stepConfig)).constructor(StepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepConfig").build()}).build();
    private static final SdkField<StepExecutionStatusDetail> EXECUTION_STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StepDetail.getter(StepDetail::executionStatusDetail)).setter(StepDetail.setter(Builder::executionStatusDetail)).constructor(StepExecutionStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatusDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_CONFIG_FIELD, EXECUTION_STATUS_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final StepConfig stepConfig;
    private final StepExecutionStatusDetail executionStatusDetail;

    private StepDetail(BuilderImpl builder) {
        this.stepConfig = builder.stepConfig;
        this.executionStatusDetail = builder.executionStatusDetail;
    }

    public StepConfig stepConfig() {
        return this.stepConfig;
    }

    public StepExecutionStatusDetail executionStatusDetail() {
        return this.executionStatusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepDetail)) {
            return false;
        }
        StepDetail other = (StepDetail)obj;
        return Objects.equals(this.stepConfig(), other.stepConfig()) && Objects.equals(this.executionStatusDetail(), other.executionStatusDetail());
    }

    public String toString() {
        return ToString.builder((String)"StepDetail").add("StepConfig", (Object)this.stepConfig()).add("ExecutionStatusDetail", (Object)this.executionStatusDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepConfig": {
                return Optional.ofNullable(clazz.cast(this.stepConfig()));
            }
            case "ExecutionStatusDetail": {
                return Optional.ofNullable(clazz.cast(this.executionStatusDetail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepDetail, T> g) {
        return obj -> g.apply((StepDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StepConfig stepConfig;
        private StepExecutionStatusDetail executionStatusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(StepDetail model) {
            this.stepConfig(model.stepConfig);
            this.executionStatusDetail(model.executionStatusDetail);
        }

        public final StepConfig.Builder getStepConfig() {
            return this.stepConfig != null ? this.stepConfig.toBuilder() : null;
        }

        @Override
        public final Builder stepConfig(StepConfig stepConfig) {
            this.stepConfig = stepConfig;
            return this;
        }

        public final void setStepConfig(StepConfig.BuilderImpl stepConfig) {
            this.stepConfig = stepConfig != null ? stepConfig.build() : null;
        }

        public final StepExecutionStatusDetail.Builder getExecutionStatusDetail() {
            return this.executionStatusDetail != null ? this.executionStatusDetail.toBuilder() : null;
        }

        @Override
        public final Builder executionStatusDetail(StepExecutionStatusDetail executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail;
            return this;
        }

        public final void setExecutionStatusDetail(StepExecutionStatusDetail.BuilderImpl executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail != null ? executionStatusDetail.build() : null;
        }

        public StepDetail build() {
            return new StepDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepDetail> {
        public Builder stepConfig(StepConfig var1);

        default public Builder stepConfig(Consumer<StepConfig.Builder> stepConfig) {
            return this.stepConfig((StepConfig)((StepConfig.Builder)StepConfig.builder().applyMutation(stepConfig)).build());
        }

        public Builder executionStatusDetail(StepExecutionStatusDetail var1);

        default public Builder executionStatusDetail(Consumer<StepExecutionStatusDetail.Builder> executionStatusDetail) {
            return this.executionStatusDetail((StepExecutionStatusDetail)((StepExecutionStatusDetail.Builder)StepExecutionStatusDetail.builder().applyMutation(executionStatusDetail)).build());
        }
    }
}

