/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceGroupDetail;
import software.amazon.awssdk.services.emr.model.InstanceGroupDetailListCopier;
import software.amazon.awssdk.services.emr.model.PlacementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobFlowInstancesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobFlowInstancesDetail> {
    private static final SdkField<String> MASTER_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::masterInstanceType)).setter(JobFlowInstancesDetail.setter(Builder::masterInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterInstanceType").build()}).build();
    private static final SdkField<String> MASTER_PUBLIC_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::masterPublicDnsName)).setter(JobFlowInstancesDetail.setter(Builder::masterPublicDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPublicDnsName").build()}).build();
    private static final SdkField<String> MASTER_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::masterInstanceId)).setter(JobFlowInstancesDetail.setter(Builder::masterInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterInstanceId").build()}).build();
    private static final SdkField<String> SLAVE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::slaveInstanceType)).setter(JobFlowInstancesDetail.setter(Builder::slaveInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlaveInstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::instanceCount)).setter(JobFlowInstancesDetail.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<List<InstanceGroupDetail>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::instanceGroups)).setter(JobFlowInstancesDetail.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceGroupDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NORMALIZED_INSTANCE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::normalizedInstanceHours)).setter(JobFlowInstancesDetail.setter(Builder::normalizedInstanceHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NormalizedInstanceHours").build()}).build();
    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::ec2KeyName)).setter(JobFlowInstancesDetail.setter(Builder::ec2KeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2KeyName").build()}).build();
    private static final SdkField<String> EC2_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::ec2SubnetId)).setter(JobFlowInstancesDetail.setter(Builder::ec2SubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SubnetId").build()}).build();
    private static final SdkField<PlacementType> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::placement)).setter(JobFlowInstancesDetail.setter(Builder::placement)).constructor(PlacementType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final SdkField<Boolean> KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::keepJobFlowAliveWhenNoSteps)).setter(JobFlowInstancesDetail.setter(Builder::keepJobFlowAliveWhenNoSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepJobFlowAliveWhenNoSteps").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::terminationProtected)).setter(JobFlowInstancesDetail.setter(Builder::terminationProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtected").build()}).build();
    private static final SdkField<String> HADOOP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobFlowInstancesDetail.getter(JobFlowInstancesDetail::hadoopVersion)).setter(JobFlowInstancesDetail.setter(Builder::hadoopVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HadoopVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_INSTANCE_TYPE_FIELD, MASTER_PUBLIC_DNS_NAME_FIELD, MASTER_INSTANCE_ID_FIELD, SLAVE_INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_GROUPS_FIELD, NORMALIZED_INSTANCE_HOURS_FIELD, EC2_KEY_NAME_FIELD, EC2_SUBNET_ID_FIELD, PLACEMENT_FIELD, KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD, TERMINATION_PROTECTED_FIELD, HADOOP_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String masterInstanceType;
    private final String masterPublicDnsName;
    private final String masterInstanceId;
    private final String slaveInstanceType;
    private final Integer instanceCount;
    private final List<InstanceGroupDetail> instanceGroups;
    private final Integer normalizedInstanceHours;
    private final String ec2KeyName;
    private final String ec2SubnetId;
    private final PlacementType placement;
    private final Boolean keepJobFlowAliveWhenNoSteps;
    private final Boolean terminationProtected;
    private final String hadoopVersion;

    private JobFlowInstancesDetail(BuilderImpl builder) {
        this.masterInstanceType = builder.masterInstanceType;
        this.masterPublicDnsName = builder.masterPublicDnsName;
        this.masterInstanceId = builder.masterInstanceId;
        this.slaveInstanceType = builder.slaveInstanceType;
        this.instanceCount = builder.instanceCount;
        this.instanceGroups = builder.instanceGroups;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.ec2KeyName = builder.ec2KeyName;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.placement = builder.placement;
        this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
        this.terminationProtected = builder.terminationProtected;
        this.hadoopVersion = builder.hadoopVersion;
    }

    public String masterInstanceType() {
        return this.masterInstanceType;
    }

    public String masterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public String masterInstanceId() {
        return this.masterInstanceId;
    }

    public String slaveInstanceType() {
        return this.slaveInstanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<InstanceGroupDetail> instanceGroups() {
        return this.instanceGroups;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public PlacementType placement() {
        return this.placement;
    }

    public Boolean keepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public String hadoopVersion() {
        return this.hadoopVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.masterInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterPublicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slaveInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalizedInstanceHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepJobFlowAliveWhenNoSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.hadoopVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesDetail)) {
            return false;
        }
        JobFlowInstancesDetail other = (JobFlowInstancesDetail)obj;
        return Objects.equals(this.masterInstanceType(), other.masterInstanceType()) && Objects.equals(this.masterPublicDnsName(), other.masterPublicDnsName()) && Objects.equals(this.masterInstanceId(), other.masterInstanceId()) && Objects.equals(this.slaveInstanceType(), other.slaveInstanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.normalizedInstanceHours(), other.normalizedInstanceHours()) && Objects.equals(this.ec2KeyName(), other.ec2KeyName()) && Objects.equals(this.ec2SubnetId(), other.ec2SubnetId()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.keepJobFlowAliveWhenNoSteps(), other.keepJobFlowAliveWhenNoSteps()) && Objects.equals(this.terminationProtected(), other.terminationProtected()) && Objects.equals(this.hadoopVersion(), other.hadoopVersion());
    }

    public String toString() {
        return ToString.builder((String)"JobFlowInstancesDetail").add("MasterInstanceType", (Object)this.masterInstanceType()).add("MasterPublicDnsName", (Object)this.masterPublicDnsName()).add("MasterInstanceId", (Object)this.masterInstanceId()).add("SlaveInstanceType", (Object)this.slaveInstanceType()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceGroups", this.instanceGroups()).add("NormalizedInstanceHours", (Object)this.normalizedInstanceHours()).add("Ec2KeyName", (Object)this.ec2KeyName()).add("Ec2SubnetId", (Object)this.ec2SubnetId()).add("Placement", (Object)this.placement()).add("KeepJobFlowAliveWhenNoSteps", (Object)this.keepJobFlowAliveWhenNoSteps()).add("TerminationProtected", (Object)this.terminationProtected()).add("HadoopVersion", (Object)this.hadoopVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterInstanceType": {
                return Optional.ofNullable(clazz.cast(this.masterInstanceType()));
            }
            case "MasterPublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.masterPublicDnsName()));
            }
            case "MasterInstanceId": {
                return Optional.ofNullable(clazz.cast(this.masterInstanceId()));
            }
            case "SlaveInstanceType": {
                return Optional.ofNullable(clazz.cast(this.slaveInstanceType()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "NormalizedInstanceHours": {
                return Optional.ofNullable(clazz.cast(this.normalizedInstanceHours()));
            }
            case "Ec2KeyName": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyName()));
            }
            case "Ec2SubnetId": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetId()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "KeepJobFlowAliveWhenNoSteps": {
                return Optional.ofNullable(clazz.cast(this.keepJobFlowAliveWhenNoSteps()));
            }
            case "TerminationProtected": {
                return Optional.ofNullable(clazz.cast(this.terminationProtected()));
            }
            case "HadoopVersion": {
                return Optional.ofNullable(clazz.cast(this.hadoopVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobFlowInstancesDetail, T> g) {
        return obj -> g.apply((JobFlowInstancesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String masterInstanceType;
        private String masterPublicDnsName;
        private String masterInstanceId;
        private String slaveInstanceType;
        private Integer instanceCount;
        private List<InstanceGroupDetail> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private Integer normalizedInstanceHours;
        private String ec2KeyName;
        private String ec2SubnetId;
        private PlacementType placement;
        private Boolean keepJobFlowAliveWhenNoSteps;
        private Boolean terminationProtected;
        private String hadoopVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowInstancesDetail model) {
            this.masterInstanceType(model.masterInstanceType);
            this.masterPublicDnsName(model.masterPublicDnsName);
            this.masterInstanceId(model.masterInstanceId);
            this.slaveInstanceType(model.slaveInstanceType);
            this.instanceCount(model.instanceCount);
            this.instanceGroups(model.instanceGroups);
            this.normalizedInstanceHours(model.normalizedInstanceHours);
            this.ec2KeyName(model.ec2KeyName);
            this.ec2SubnetId(model.ec2SubnetId);
            this.placement(model.placement);
            this.keepJobFlowAliveWhenNoSteps(model.keepJobFlowAliveWhenNoSteps);
            this.terminationProtected(model.terminationProtected);
            this.hadoopVersion(model.hadoopVersion);
        }

        public final String getMasterInstanceType() {
            return this.masterInstanceType;
        }

        @Override
        public final Builder masterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        public final void setMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
        }

        public final String getMasterPublicDnsName() {
            return this.masterPublicDnsName;
        }

        @Override
        public final Builder masterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
            return this;
        }

        public final void setMasterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
        }

        public final String getMasterInstanceId() {
            return this.masterInstanceId;
        }

        @Override
        public final Builder masterInstanceId(String masterInstanceId) {
            this.masterInstanceId = masterInstanceId;
            return this;
        }

        public final void setMasterInstanceId(String masterInstanceId) {
            this.masterInstanceId = masterInstanceId;
        }

        public final String getSlaveInstanceType() {
            return this.slaveInstanceType;
        }

        @Override
        public final Builder slaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
            return this;
        }

        public final void setSlaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<InstanceGroupDetail.Builder> getInstanceGroups() {
            return this.instanceGroups != null ? (Collection)this.instanceGroups.stream().map(InstanceGroupDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
            this.instanceGroups = InstanceGroupDetailListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupDetail ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupDetail.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (InstanceGroupDetail)((InstanceGroupDetail.Builder)InstanceGroupDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupDetail.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupDetailListCopier.copyFromBuilder(instanceGroups);
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final PlacementType.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(PlacementType placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(PlacementType.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final Boolean getKeepJobFlowAliveWhenNoSteps() {
            return this.keepJobFlowAliveWhenNoSteps;
        }

        @Override
        public final Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        public final void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final String getHadoopVersion() {
            return this.hadoopVersion;
        }

        @Override
        public final Builder hadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
            return this;
        }

        public final void setHadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
        }

        public JobFlowInstancesDetail build() {
            return new JobFlowInstancesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobFlowInstancesDetail> {
        public Builder masterInstanceType(String var1);

        public Builder masterPublicDnsName(String var1);

        public Builder masterInstanceId(String var1);

        public Builder slaveInstanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceGroups(Collection<InstanceGroupDetail> var1);

        public Builder instanceGroups(InstanceGroupDetail ... var1);

        public Builder instanceGroups(Consumer<InstanceGroupDetail.Builder> ... var1);

        public Builder normalizedInstanceHours(Integer var1);

        public Builder ec2KeyName(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder placement(PlacementType var1);

        default public Builder placement(Consumer<PlacementType.Builder> placement) {
            return this.placement((PlacementType)((PlacementType.Builder)PlacementType.builder().applyMutation(placement)).build());
        }

        public Builder keepJobFlowAliveWhenNoSteps(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder hadoopVersion(String var1);
    }
}

