/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.StepTimeline;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepTimelineMarshaller {
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").isBinary(false).build();
    private static final StepTimelineMarshaller INSTANCE = new StepTimelineMarshaller();

    private StepTimelineMarshaller() {
    }

    public static StepTimelineMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepTimeline stepTimeline, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepTimeline, (String)"stepTimeline");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepTimeline.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)stepTimeline.startDateTime(), STARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)stepTimeline.endDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

