/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ACTIONONFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionOnFailure").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HADOOPJARSTEP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HadoopJarStep").isBinary(false).build();
    private static final StepConfigMarshaller INSTANCE = new StepConfigMarshaller();

    private StepConfigMarshaller() {
    }

    public static StepConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepConfig stepConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepConfig, (String)"stepConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stepConfig.actionOnFailureAsString(), ACTIONONFAILURE_BINDING);
            protocolMarshaller.marshall((Object)stepConfig.hadoopJarStep(), HADOOPJARSTEP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

