/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecurityConfigurationSummaryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final SecurityConfigurationSummaryMarshaller INSTANCE = new SecurityConfigurationSummaryMarshaller();

    private SecurityConfigurationSummaryMarshaller() {
    }

    public static SecurityConfigurationSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityConfigurationSummary securityConfigurationSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)securityConfigurationSummary, (String)"securityConfigurationSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)securityConfigurationSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)securityConfigurationSummary.creationDateTime(), CREATIONDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

