/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScalingRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScalingRuleMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRIGGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Trigger").isBinary(false).build();
    private static final ScalingRuleMarshaller INSTANCE = new ScalingRuleMarshaller();

    private ScalingRuleMarshaller() {
    }

    public static ScalingRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingRule scalingRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scalingRule, (String)"scalingRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scalingRule.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)scalingRule.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)scalingRule.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)scalingRule.trigger(), TRIGGER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

