/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceFleetConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEFLEETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetType").isBinary(false).build();
    private static final MarshallingInfo<Integer> TARGETONDEMANDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetOnDemandCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> TARGETSPOTCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetSpotCapacity").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCETYPECONFIGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceTypeConfigs").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAUNCHSPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchSpecifications").isBinary(false).build();
    private static final InstanceFleetConfigMarshaller INSTANCE = new InstanceFleetConfigMarshaller();

    private InstanceFleetConfigMarshaller() {
    }

    public static InstanceFleetConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceFleetConfig instanceFleetConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceFleetConfig, (String)"instanceFleetConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceFleetConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceFleetConfig.instanceFleetTypeAsString(), INSTANCEFLEETTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceFleetConfig.targetOnDemandCapacity(), TARGETONDEMANDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleetConfig.targetSpotCapacity(), TARGETSPOTCAPACITY_BINDING);
            protocolMarshaller.marshall(instanceFleetConfig.instanceTypeConfigs(), INSTANCETYPECONFIGS_BINDING);
            protocolMarshaller.marshall((Object)instanceFleetConfig.launchSpecifications(), LAUNCHSPECIFICATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

