/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig;
import software.amazon.awssdk.services.emr.transform.VolumeSpecificationUnmarshaller;

public class EbsBlockDeviceConfigUnmarshaller
implements Unmarshaller<EbsBlockDeviceConfig, JsonUnmarshallerContext> {
    private static final EbsBlockDeviceConfigUnmarshaller INSTANCE = new EbsBlockDeviceConfigUnmarshaller();

    public EbsBlockDeviceConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        EbsBlockDeviceConfig.Builder ebsBlockDeviceConfigBuilder = EbsBlockDeviceConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VolumeSpecification", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceConfigBuilder.volumeSpecification(VolumeSpecificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("VolumesPerInstance", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceConfigBuilder.volumesPerInstance((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EbsBlockDeviceConfig)ebsBlockDeviceConfigBuilder.build();
    }

    public static EbsBlockDeviceConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

