/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ClusterTimeline;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterTimelineMarshaller {
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> READYDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadyDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").isBinary(false).build();
    private static final ClusterTimelineMarshaller INSTANCE = new ClusterTimelineMarshaller();

    private ClusterTimelineMarshaller() {
    }

    public static ClusterTimelineMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClusterTimeline clusterTimeline, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)clusterTimeline, (String)"clusterTimeline");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)clusterTimeline.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)clusterTimeline.readyDateTime(), READYDATETIME_BINDING);
            protocolMarshaller.marshall((Object)clusterTimeline.endDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

