/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.Application;

public class ApplicationUnmarshaller
implements Unmarshaller<Application, JsonUnmarshallerContext> {
    private static final ApplicationUnmarshaller INSTANCE = new ApplicationUnmarshaller();

    public Application unmarshall(JsonUnmarshallerContext context) throws Exception {
        Application.Builder applicationBuilder = Application.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    applicationBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    applicationBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Args", targetDepth)) {
                    context.nextToken();
                    applicationBuilder.args(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AdditionalInfo", targetDepth)) {
                    context.nextToken();
                    applicationBuilder.additionalInfo(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Application)applicationBuilder.build();
    }

    public static ApplicationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

