/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.emr.EMRAsyncClient;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.StepSummary;

public class ListStepsPublisher
implements SdkPublisher<ListStepsResponse> {
    private final EMRAsyncClient client;
    private final ListStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStepsPublisher(EMRAsyncClient client, ListStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStepsPublisher(EMRAsyncClient client, ListStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<StepSummary> steps() {
        Function<ListStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListStepsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListStepsPublisher resume(ListStepsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStepsPublisher(this.client, (ListStepsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListStepsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListStepsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListStepsResponseFetcher
    implements AsyncPageFetcher<ListStepsResponse> {
        private ListStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListStepsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListStepsResponse> nextPage(ListStepsResponse previousPage) {
            if (previousPage == null) {
                return ListStepsPublisher.this.client.listSteps(ListStepsPublisher.this.firstRequest);
            }
            return ListStepsPublisher.this.client.listSteps((ListStepsRequest)((Object)ListStepsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

