/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;

public class ListInstanceGroupsIterable
implements SdkIterable<ListInstanceGroupsResponse> {
    private final EMRClient client;
    private final ListInstanceGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceGroupsIterable(EMRClient client, ListInstanceGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceGroupsResponseFetcher();
    }

    public Iterator<ListInstanceGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<InstanceGroup> instanceGroups() {
        Function<ListInstanceGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceGroups() != null) {
                return response.instanceGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListInstanceGroupsIterable resume(ListInstanceGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceGroupsIterable(this.client, (ListInstanceGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInstanceGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInstanceGroupsResponseFetcher
    implements SyncPageFetcher<ListInstanceGroupsResponse> {
        private ListInstanceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListInstanceGroupsResponse nextPage(ListInstanceGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceGroupsIterable.this.client.listInstanceGroups(ListInstanceGroupsIterable.this.firstRequest);
            }
            return ListInstanceGroupsIterable.this.client.listInstanceGroups((ListInstanceGroupsRequest)((Object)ListInstanceGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

