/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.emr.EMRAsyncClient;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;

public class ListInstanceFleetsPublisher
implements SdkPublisher<ListInstanceFleetsResponse> {
    private final EMRAsyncClient client;
    private final ListInstanceFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceFleetsPublisher(EMRAsyncClient client, ListInstanceFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceFleetsPublisher(EMRAsyncClient client, ListInstanceFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<InstanceFleet> instanceFleets() {
        Function<ListInstanceFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceFleets() != null) {
                return response.instanceFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListInstanceFleetsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListInstanceFleetsPublisher resume(ListInstanceFleetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceFleetsPublisher(this.client, (ListInstanceFleetsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceFleetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstanceFleetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstanceFleetsResponseFetcher
    implements AsyncPageFetcher<ListInstanceFleetsResponse> {
        private ListInstanceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceFleetsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListInstanceFleetsResponse> nextPage(ListInstanceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceFleetsPublisher.this.client.listInstanceFleets(ListInstanceFleetsPublisher.this.firstRequest);
            }
            return ListInstanceFleetsPublisher.this.client.listInstanceFleets((ListInstanceFleetsRequest)((Object)ListInstanceFleetsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

