/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicy;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutAutoScalingPolicyRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, PutAutoScalingPolicyRequest> {
    private final String clusterId;
    private final String instanceGroupId;
    private final AutoScalingPolicy autoScalingPolicy;

    private PutAutoScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public AutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoScalingPolicyRequest)) {
            return false;
        }
        PutAutoScalingPolicyRequest other = (PutAutoScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy());
    }

    public String toString() {
        return ToString.builder((String)"PutAutoScalingPolicyRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.of(clazz.cast(this.instanceGroupId()));
            }
            case "AutoScalingPolicy": {
                return Optional.of(clazz.cast(this.autoScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoScalingPolicyRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final AutoScalingPolicy.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutAutoScalingPolicyRequest build() {
            return new PutAutoScalingPolicyRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, PutAutoScalingPolicyRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder autoScalingPolicy(AutoScalingPolicy var1);

        default public Builder autoScalingPolicy(Consumer<AutoScalingPolicy.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((AutoScalingPolicy)((AutoScalingPolicy.Builder)AutoScalingPolicy.builder().apply(autoScalingPolicy)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

