/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.EbsVolumeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsVolume
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsVolume> {
    private final String device;
    private final String volumeId;

    private EbsVolume(BuilderImpl builder) {
        this.device = builder.device;
        this.volumeId = builder.volumeId;
    }

    public String device() {
        return this.device;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolume)) {
            return false;
        }
        EbsVolume other = (EbsVolume)obj;
        return Objects.equals(this.device(), other.device()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        return ToString.builder((String)"EbsVolume").add("Device", (Object)this.device()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Device": {
                return Optional.of(clazz.cast(this.device()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsVolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String device;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolume model) {
            this.device(model.device);
            this.volumeId(model.volumeId);
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public EbsVolume build() {
            return new EbsVolume(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsVolume> {
        public Builder device(String var1);

        public Builder volumeId(String var1);
    }
}

