/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.services.emr.transform.EbsBlockDeviceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsBlockDevice
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsBlockDevice> {
    private final VolumeSpecification volumeSpecification;
    private final String device;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.device = builder.device;
    }

    public VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public String device() {
        return this.device;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        return Objects.equals(this.volumeSpecification(), other.volumeSpecification()) && Objects.equals(this.device(), other.device());
    }

    public String toString() {
        return ToString.builder((String)"EbsBlockDevice").add("VolumeSpecification", (Object)this.volumeSpecification()).add("Device", (Object)this.device()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSpecification": {
                return Optional.of(clazz.cast(this.volumeSpecification()));
            }
            case "Device": {
                return Optional.of(clazz.cast(this.device()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.volumeSpecification(model.volumeSpecification);
            this.device(model.device);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return this.volumeSpecification != null ? this.volumeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder volumeSpecification(VolumeSpecification var1);

        default public Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return this.volumeSpecification((VolumeSpecification)((VolumeSpecification.Builder)VolumeSpecification.builder().apply(volumeSpecification)).build());
        }

        public Builder device(String var1);
    }
}

