/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ClusterState;
import software.amazon.awssdk.services.emr.model.ClusterStateChangeReason;
import software.amazon.awssdk.services.emr.model.ClusterTimeline;
import software.amazon.awssdk.services.emr.transform.ClusterStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterStatus> {
    private final String state;
    private final ClusterStateChangeReason stateChangeReason;
    private final ClusterTimeline timeline;

    private ClusterStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ClusterStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public ClusterTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterStatus)) {
            return false;
        }
        ClusterStatus other = (ClusterStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.timeline(), other.timeline());
    }

    public String toString() {
        return ToString.builder((String)"ClusterStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Timeline", (Object)this.timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.of(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private ClusterStateChangeReason stateChangeReason;
        private ClusterTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ClusterStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ClusterStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ClusterStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final ClusterTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(ClusterTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(ClusterTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public ClusterStatus build() {
            return new ClusterStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterStatus> {
        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateChangeReason(ClusterStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ClusterStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ClusterStateChangeReason)((ClusterStateChangeReason.Builder)ClusterStateChangeReason.builder().apply(stateChangeReason)).build());
        }

        public Builder timeline(ClusterTimeline var1);

        default public Builder timeline(Consumer<ClusterTimeline.Builder> timeline) {
            return this.timeline((ClusterTimeline)((ClusterTimeline.Builder)ClusterTimeline.builder().apply(timeline)).build());
        }
    }
}

