/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.waiters.ClusterRunning;
import software.amazon.awssdk.services.emr.waiters.ClusterTerminated;
import software.amazon.awssdk.services.emr.waiters.DescribeClusterFunction;
import software.amazon.awssdk.services.emr.waiters.DescribeStepFunction;
import software.amazon.awssdk.services.emr.waiters.StepComplete;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class EMRClientWaiters {
    private final EMRClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public EMRClientWaiters(EMRClient client) {
        this.client = client;
    }

    public Waiter<DescribeClusterRequest> clusterRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterRunning.IsRUNNINGMatcher(), new ClusterRunning.IsWAITINGMatcher(), new ClusterRunning.IsTERMINATINGMatcher(), new ClusterRunning.IsTERMINATEDMatcher(), new ClusterRunning.IsTERMINATED_WITH_ERRORSMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStepRequest> stepComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStepFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StepComplete.IsCOMPLETEDMatcher(), new StepComplete.IsFAILEDMatcher(), new StepComplete.IsCANCELLEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterRequest> clusterTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterTerminated.IsTERMINATEDMatcher(), new ClusterTerminated.IsTERMINATED_WITH_ERRORSMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

