/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig;

@SdkInternalApi
public class JobFlowInstancesConfigMarshaller {
    private static final MarshallingInfo<String> MASTERINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterInstanceType").build();
    private static final MarshallingInfo<String> SLAVEINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SlaveInstanceType").build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").build();
    private static final MarshallingInfo<List> INSTANCEGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroups").build();
    private static final MarshallingInfo<List> INSTANCEFLEETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleets").build();
    private static final MarshallingInfo<String> EC2KEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2KeyName").build();
    private static final MarshallingInfo<StructuredPojo> PLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Placement").build();
    private static final MarshallingInfo<Boolean> KEEPJOBFLOWALIVEWHENNOSTEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeepJobFlowAliveWhenNoSteps").build();
    private static final MarshallingInfo<Boolean> TERMINATIONPROTECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationProtected").build();
    private static final MarshallingInfo<String> HADOOPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HadoopVersion").build();
    private static final MarshallingInfo<String> EC2SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2SubnetId").build();
    private static final MarshallingInfo<List> EC2SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2SubnetIds").build();
    private static final MarshallingInfo<String> EMRMANAGEDMASTERSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedMasterSecurityGroup").build();
    private static final MarshallingInfo<String> EMRMANAGEDSLAVESECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedSlaveSecurityGroup").build();
    private static final MarshallingInfo<String> SERVICEACCESSSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessSecurityGroup").build();
    private static final MarshallingInfo<List> ADDITIONALMASTERSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalMasterSecurityGroups").build();
    private static final MarshallingInfo<List> ADDITIONALSLAVESECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalSlaveSecurityGroups").build();
    private static final JobFlowInstancesConfigMarshaller instance = new JobFlowInstancesConfigMarshaller();

    public static JobFlowInstancesConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(JobFlowInstancesConfig jobFlowInstancesConfig, ProtocolMarshaller protocolMarshaller) {
        if (jobFlowInstancesConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.masterInstanceType(), MASTERINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.slaveInstanceType(), SLAVEINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.instanceGroups(), INSTANCEGROUPS_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.instanceFleets(), INSTANCEFLEETS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.ec2KeyName(), EC2KEYNAME_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.placement(), PLACEMENT_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.keepJobFlowAliveWhenNoSteps(), KEEPJOBFLOWALIVEWHENNOSTEPS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.terminationProtected(), TERMINATIONPROTECTED_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.hadoopVersion(), HADOOPVERSION_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.ec2SubnetId(), EC2SUBNETID_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.ec2SubnetIds(), EC2SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.emrManagedMasterSecurityGroup(), EMRMANAGEDMASTERSECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.emrManagedSlaveSecurityGroup(), EMRMANAGEDSLAVESECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.serviceAccessSecurityGroup(), SERVICEACCESSSECURITYGROUP_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.additionalMasterSecurityGroups(), ADDITIONALMASTERSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.additionalSlaveSecurityGroups(), ADDITIONALSLAVESECURITYGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

