/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfigListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceFleetConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceFleetConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleetConfig> {
    private final String name;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final List<InstanceTypeConfig> instanceTypeConfigs;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;

    private InstanceFleetConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.instanceTypeConfigs = builder.instanceTypeConfigs;
        this.launchSpecifications = builder.launchSpecifications;
    }

    public String name() {
        return this.name;
    }

    public String instanceFleetType() {
        return this.instanceFleetType;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public List<InstanceTypeConfig> instanceTypeConfigs() {
        return this.instanceTypeConfigs;
    }

    public InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleetType() == null ? 0 : this.instanceFleetType().hashCode());
        hashCode = 31 * hashCode + (this.targetOnDemandCapacity() == null ? 0 : this.targetOnDemandCapacity().hashCode());
        hashCode = 31 * hashCode + (this.targetSpotCapacity() == null ? 0 : this.targetSpotCapacity().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeConfigs() == null ? 0 : this.instanceTypeConfigs().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecifications() == null ? 0 : this.launchSpecifications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetConfig)) {
            return false;
        }
        InstanceFleetConfig other = (InstanceFleetConfig)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.instanceFleetType() == null ^ this.instanceFleetType() == null) {
            return false;
        }
        if (other.instanceFleetType() != null && !other.instanceFleetType().equals(this.instanceFleetType())) {
            return false;
        }
        if (other.targetOnDemandCapacity() == null ^ this.targetOnDemandCapacity() == null) {
            return false;
        }
        if (other.targetOnDemandCapacity() != null && !other.targetOnDemandCapacity().equals(this.targetOnDemandCapacity())) {
            return false;
        }
        if (other.targetSpotCapacity() == null ^ this.targetSpotCapacity() == null) {
            return false;
        }
        if (other.targetSpotCapacity() != null && !other.targetSpotCapacity().equals(this.targetSpotCapacity())) {
            return false;
        }
        if (other.instanceTypeConfigs() == null ^ this.instanceTypeConfigs() == null) {
            return false;
        }
        if (other.instanceTypeConfigs() != null && !other.instanceTypeConfigs().equals(this.instanceTypeConfigs())) {
            return false;
        }
        if (other.launchSpecifications() == null ^ this.launchSpecifications() == null) {
            return false;
        }
        return other.launchSpecifications() == null || other.launchSpecifications().equals(this.launchSpecifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.instanceFleetType() != null) {
            sb.append("InstanceFleetType: ").append(this.instanceFleetType()).append(",");
        }
        if (this.targetOnDemandCapacity() != null) {
            sb.append("TargetOnDemandCapacity: ").append(this.targetOnDemandCapacity()).append(",");
        }
        if (this.targetSpotCapacity() != null) {
            sb.append("TargetSpotCapacity: ").append(this.targetSpotCapacity()).append(",");
        }
        if (this.instanceTypeConfigs() != null) {
            sb.append("InstanceTypeConfigs: ").append(this.instanceTypeConfigs()).append(",");
        }
        if (this.launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.launchSpecifications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private List<InstanceTypeConfig> instanceTypeConfigs = new SdkInternalList();
        private InstanceFleetProvisioningSpecifications launchSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetConfig model) {
            this.setName(model.name);
            this.setInstanceFleetType(model.instanceFleetType);
            this.setTargetOnDemandCapacity(model.targetOnDemandCapacity);
            this.setTargetSpotCapacity(model.targetSpotCapacity);
            this.setInstanceTypeConfigs(model.instanceTypeConfigs);
            this.setLaunchSpecifications(model.launchSpecifications);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final void setInstanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public final Collection<InstanceTypeConfig> getInstanceTypeConfigs() {
            return this.instanceTypeConfigs;
        }

        @Override
        public final Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
            if (this.instanceTypeConfigs == null) {
                this.instanceTypeConfigs = new SdkInternalList(instanceTypeConfigs.length);
            }
            for (InstanceTypeConfig e : instanceTypeConfigs) {
                this.instanceTypeConfigs.add(e);
            }
            return this;
        }

        public final void setInstanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
        }

        @SafeVarargs
        public final void setInstanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
            if (this.instanceTypeConfigs == null) {
                this.instanceTypeConfigs = new SdkInternalList(instanceTypeConfigs.length);
            }
            for (InstanceTypeConfig e : instanceTypeConfigs) {
                this.instanceTypeConfigs.add(e);
            }
        }

        public final InstanceFleetProvisioningSpecifications getLaunchSpecifications() {
            return this.launchSpecifications;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
        }

        public InstanceFleetConfig build() {
            return new InstanceFleetConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleetConfig> {
        public Builder name(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder instanceTypeConfigs(Collection<InstanceTypeConfig> var1);

        public Builder instanceTypeConfigs(InstanceTypeConfig ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);
    }
}

