/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.StringMapCopier;
import software.amazon.awssdk.services.emr.transform.HadoopStepConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HadoopStepConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, HadoopStepConfig> {
    private final String jar;
    private final Map<String, String> properties;
    private final String mainClass;
    private final List<String> args;

    private HadoopStepConfig(BuilderImpl builder) {
        this.jar = builder.jar;
        this.properties = builder.properties;
        this.mainClass = builder.mainClass;
        this.args = builder.args;
    }

    public String jar() {
        return this.jar;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jar() == null ? 0 : this.jar().hashCode());
        hashCode = 31 * hashCode + (this.properties() == null ? 0 : this.properties().hashCode());
        hashCode = 31 * hashCode + (this.mainClass() == null ? 0 : this.mainClass().hashCode());
        hashCode = 31 * hashCode + (this.args() == null ? 0 : this.args().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopStepConfig)) {
            return false;
        }
        HadoopStepConfig other = (HadoopStepConfig)obj;
        if (other.jar() == null ^ this.jar() == null) {
            return false;
        }
        if (other.jar() != null && !other.jar().equals(this.jar())) {
            return false;
        }
        if (other.properties() == null ^ this.properties() == null) {
            return false;
        }
        if (other.properties() != null && !other.properties().equals(this.properties())) {
            return false;
        }
        if (other.mainClass() == null ^ this.mainClass() == null) {
            return false;
        }
        if (other.mainClass() != null && !other.mainClass().equals(this.mainClass())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        return other.args() == null || other.args().equals(this.args());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jar() != null) {
            sb.append("Jar: ").append(this.jar()).append(",");
        }
        if (this.properties() != null) {
            sb.append("Properties: ").append(this.properties()).append(",");
        }
        if (this.mainClass() != null) {
            sb.append("MainClass: ").append(this.mainClass()).append(",");
        }
        if (this.args() != null) {
            sb.append("Args: ").append(this.args()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HadoopStepConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jar;
        private Map<String, String> properties = new SdkInternalMap();
        private String mainClass;
        private List<String> args = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(HadoopStepConfig model) {
            this.setJar(model.jar);
            this.setProperties(model.properties);
            this.setMainClass(model.mainClass);
            this.setArgs(model.args);
        }

        public final String getJar() {
            return this.jar;
        }

        @Override
        public final Builder jar(String jar) {
            this.jar = jar;
            return this;
        }

        public final void setJar(String jar) {
            this.jar = jar;
        }

        public final Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
        }

        public final String getMainClass() {
            return this.mainClass;
        }

        @Override
        public final Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public final void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            if (this.args == null) {
                this.args = new SdkInternalList(args.length);
            }
            for (String e : args) {
                this.args.add(e);
            }
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        @SafeVarargs
        public final void setArgs(String ... args) {
            if (this.args == null) {
                this.args = new SdkInternalList(args.length);
            }
            for (String e : args) {
                this.args.add(e);
            }
        }

        public HadoopStepConfig build() {
            return new HadoopStepConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HadoopStepConfig> {
        public Builder jar(String var1);

        public Builder properties(Map<String, String> var1);

        public Builder mainClass(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

