/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionState;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobFlowsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeJobFlowsRequest> {
    private final Date createdAfter;
    private final Date createdBefore;
    private final List<String> jobFlowIds;
    private final List<String> jobFlowStates;

    private DescribeJobFlowsRequest(BuilderImpl builder) {
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.jobFlowIds = builder.jobFlowIds;
        this.jobFlowStates = builder.jobFlowStates;
    }

    public Date createdAfter() {
        return this.createdAfter;
    }

    public Date createdBefore() {
        return this.createdBefore;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public List<String> jobFlowStates() {
        return this.jobFlowStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createdAfter() == null ? 0 : this.createdAfter().hashCode());
        hashCode = 31 * hashCode + (this.createdBefore() == null ? 0 : this.createdBefore().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowIds() == null ? 0 : this.jobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowStates() == null ? 0 : this.jobFlowStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsRequest)) {
            return false;
        }
        DescribeJobFlowsRequest other = (DescribeJobFlowsRequest)((Object)obj);
        if (other.createdAfter() == null ^ this.createdAfter() == null) {
            return false;
        }
        if (other.createdAfter() != null && !other.createdAfter().equals(this.createdAfter())) {
            return false;
        }
        if (other.createdBefore() == null ^ this.createdBefore() == null) {
            return false;
        }
        if (other.createdBefore() != null && !other.createdBefore().equals(this.createdBefore())) {
            return false;
        }
        if (other.jobFlowIds() == null ^ this.jobFlowIds() == null) {
            return false;
        }
        if (other.jobFlowIds() != null && !other.jobFlowIds().equals(this.jobFlowIds())) {
            return false;
        }
        if (other.jobFlowStates() == null ^ this.jobFlowStates() == null) {
            return false;
        }
        return other.jobFlowStates() == null || other.jobFlowStates().equals(this.jobFlowStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createdAfter() != null) {
            sb.append("CreatedAfter: ").append(this.createdAfter()).append(",");
        }
        if (this.createdBefore() != null) {
            sb.append("CreatedBefore: ").append(this.createdBefore()).append(",");
        }
        if (this.jobFlowIds() != null) {
            sb.append("JobFlowIds: ").append(this.jobFlowIds()).append(",");
        }
        if (this.jobFlowStates() != null) {
            sb.append("JobFlowStates: ").append(this.jobFlowStates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Date createdAfter;
        private Date createdBefore;
        private List<String> jobFlowIds = new SdkInternalList();
        private List<String> jobFlowStates = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsRequest model) {
            this.setCreatedAfter(model.createdAfter);
            this.setCreatedBefore(model.createdBefore);
            this.setJobFlowIds(model.jobFlowIds);
            this.setJobFlowStates(model.jobFlowStates);
        }

        public final Date getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Date createdAfter) {
            this.createdAfter = StandardMemberCopier.copy((Date)createdAfter);
            return this;
        }

        public final void setCreatedAfter(Date createdAfter) {
            this.createdAfter = StandardMemberCopier.copy((Date)createdAfter);
        }

        public final Date getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Date createdBefore) {
            this.createdBefore = StandardMemberCopier.copy((Date)createdBefore);
            return this;
        }

        public final void setCreatedBefore(Date createdBefore) {
            this.createdBefore = StandardMemberCopier.copy((Date)createdBefore);
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            if (this.jobFlowIds == null) {
                this.jobFlowIds = new SdkInternalList(jobFlowIds.length);
            }
            for (String e : jobFlowIds) {
                this.jobFlowIds.add(e);
            }
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @SafeVarargs
        public final void setJobFlowIds(String ... jobFlowIds) {
            if (this.jobFlowIds == null) {
                this.jobFlowIds = new SdkInternalList(jobFlowIds.length);
            }
            for (String e : jobFlowIds) {
                this.jobFlowIds.add(e);
            }
        }

        public final Collection<String> getJobFlowStates() {
            return this.jobFlowStates;
        }

        @Override
        public final Builder jobFlowStates(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowStates(String ... jobFlowStates) {
            if (this.jobFlowStates == null) {
                this.jobFlowStates = new SdkInternalList(jobFlowStates.length);
            }
            for (String e : jobFlowStates) {
                this.jobFlowStates.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowStates(JobFlowExecutionState ... jobFlowStates) {
            if (this.jobFlowStates == null) {
                this.jobFlowStates = new SdkInternalList(jobFlowStates.length);
            }
            for (JobFlowExecutionState ele : jobFlowStates) {
                this.jobFlowStates.add(ele.toString());
            }
            return this;
        }

        public final void setJobFlowStates(Collection<String> jobFlowStates) {
            this.jobFlowStates = JobFlowExecutionStateListCopier.copy(jobFlowStates);
        }

        @SafeVarargs
        public final void setJobFlowStates(String ... jobFlowStates) {
            if (this.jobFlowStates == null) {
                this.jobFlowStates = new SdkInternalList(jobFlowStates.length);
            }
            for (String e : jobFlowStates) {
                this.jobFlowStates.add(e);
            }
        }

        @SafeVarargs
        public final void setJobFlowStates(JobFlowExecutionState ... jobFlowStates) {
            if (this.jobFlowStates == null) {
                this.jobFlowStates = new SdkInternalList(jobFlowStates.length);
            }
            for (JobFlowExecutionState ele : jobFlowStates) {
                this.jobFlowStates.add(ele.toString());
            }
        }

        public DescribeJobFlowsRequest build() {
            return new DescribeJobFlowsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobFlowsRequest> {
        public Builder createdAfter(Date var1);

        public Builder createdBefore(Date var1);

        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder jobFlowStates(Collection<String> var1);

        public Builder jobFlowStates(String ... var1);

        public Builder jobFlowStates(JobFlowExecutionState ... var1);
    }
}

