/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.StepIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelStepsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CancelStepsRequest> {
    private final String clusterId;
    private final List<String> stepIds;

    private CancelStepsRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.stepIds = builder.stepIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<String> stepIds() {
        return this.stepIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.stepIds() == null ? 0 : this.stepIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest)((Object)obj);
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.stepIds() == null ^ this.stepIds() == null) {
            return false;
        }
        return other.stepIds() == null || other.stepIds().equals(this.stepIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.stepIds() != null) {
            sb.append("StepIds: ").append(this.stepIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsRequest model) {
            this.setClusterId(model.clusterId);
            this.setStepIds(model.stepIds);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepIds() {
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            if (this.stepIds == null) {
                this.stepIds = new SdkInternalList(stepIds.length);
            }
            for (String e : stepIds) {
                this.stepIds.add(e);
            }
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        @SafeVarargs
        public final void setStepIds(String ... stepIds) {
            if (this.stepIds == null) {
                this.stepIds = new SdkInternalList(stepIds.length);
            }
            for (String e : stepIds) {
                this.stepIds.add(e);
            }
        }

        public CancelStepsRequest build() {
            return new CancelStepsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);
    }
}

