/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.ScalingConstraints;
import software.amazon.awssdk.services.emr.model.ScalingRule;
import software.amazon.awssdk.services.emr.model.ScalingRuleListCopier;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicy> {
    private final ScalingConstraints constraints;
    private final List<ScalingRule> rules;

    private AutoScalingPolicy(BuilderImpl builder) {
        this.constraints = builder.constraints;
        this.rules = builder.rules;
    }

    public ScalingConstraints constraints() {
        return this.constraints;
    }

    public List<ScalingRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.constraints() == null ? 0 : this.constraints().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicy)) {
            return false;
        }
        AutoScalingPolicy other = (AutoScalingPolicy)obj;
        if (other.constraints() == null ^ this.constraints() == null) {
            return false;
        }
        if (other.constraints() != null && !other.constraints().equals(this.constraints())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.constraints() != null) {
            sb.append("Constraints: ").append(this.constraints()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ScalingConstraints constraints;
        private List<ScalingRule> rules = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicy model) {
            this.setConstraints(model.constraints);
            this.setRules(model.rules);
        }

        public final ScalingConstraints getConstraints() {
            return this.constraints;
        }

        @Override
        public final Builder constraints(ScalingConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(ScalingConstraints constraints) {
            this.constraints = constraints;
        }

        public final Collection<ScalingRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<ScalingRule> rules) {
            this.rules = ScalingRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ScalingRule ... rules) {
            if (this.rules == null) {
                this.rules = new SdkInternalList(rules.length);
            }
            for (ScalingRule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<ScalingRule> rules) {
            this.rules = ScalingRuleListCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(ScalingRule ... rules) {
            if (this.rules == null) {
                this.rules = new SdkInternalList(rules.length);
            }
            for (ScalingRule e : rules) {
                this.rules.add(e);
            }
        }

        public AutoScalingPolicy build() {
            return new AutoScalingPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicy> {
        public Builder constraints(ScalingConstraints var1);

        public Builder rules(Collection<ScalingRule> var1);

        public Builder rules(ScalingRule ... var1);
    }
}

