/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.model.Job;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse;

public class ListJobsByPipelineIterable
implements SdkIterable<ListJobsByPipelineResponse> {
    private final ElasticTranscoderClient client;
    private final ListJobsByPipelineRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsByPipelineIterable(ElasticTranscoderClient client, ListJobsByPipelineRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobsByPipelineResponseFetcher();
    }

    public Iterator<ListJobsByPipelineResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Job> jobs() {
        Function<ListJobsByPipelineResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobsByPipelineResponseFetcher
    implements SyncPageFetcher<ListJobsByPipelineResponse> {
        private ListJobsByPipelineResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByPipelineResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListJobsByPipelineResponse nextPage(ListJobsByPipelineResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByPipelineIterable.this.client.listJobsByPipeline(ListJobsByPipelineIterable.this.firstRequest);
            }
            return ListJobsByPipelineIterable.this.client.listJobsByPipeline((ListJobsByPipelineRequest)((Object)ListJobsByPipelineIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

