/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ListJobsByPipelineResponse</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsByPipelineResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ListJobsByPipelineResponse.Builder, ListJobsByPipelineResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField
            .<List<Job>> builder(MarshallingType.LIST)
            .memberName("Jobs")
            .getter(getter(ListJobsByPipelineResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Job> builder(MarshallingType.SDK_POJO)
                                            .constructor(Job::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListJobsByPipelineResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Job> jobs;

    private final String nextPageToken;

    private ListJobsByPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Job</code> objects that are in the specified pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Job</code> objects that are in the specified pipeline.
     */
    public final List<Job> jobs() {
        return jobs;
    }

    /**
     * <p>
     * A value that you use to access the second and subsequent pages of results, if any. When the jobs in the specified
     * pipeline fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code>
     * is <code>null</code>.
     * </p>
     * 
     * @return A value that you use to access the second and subsequent pages of results, if any. When the jobs in the
     *         specified pipeline fit on one page or when you've reached the last page of results, the value of
     *         <code>NextPageToken</code> is <code>null</code>.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByPipelineResponse)) {
            return false;
        }
        ListJobsByPipelineResponse other = (ListJobsByPipelineResponse) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsByPipelineResponse").add("Jobs", hasJobs() ? jobs() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsByPipelineResponse, T> g) {
        return obj -> g.apply((ListJobsByPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListJobsByPipelineResponse> {
        /**
         * <p>
         * An array of <code>Job</code> objects that are in the specified pipeline.
         * </p>
         * 
         * @param jobs
         *        An array of <code>Job</code> objects that are in the specified pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<Job> jobs);

        /**
         * <p>
         * An array of <code>Job</code> objects that are in the specified pipeline.
         * </p>
         * 
         * @param jobs
         *        An array of <code>Job</code> objects that are in the specified pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Job... jobs);

        /**
         * <p>
         * An array of <code>Job</code> objects that are in the specified pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Job>.Builder} avoiding the need to create
         * one manually via {@link List<Job>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Job>.Builder#build()} is called immediately and its result
         * is passed to {@link #jobs(List<Job>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<Job>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<Job>)
         */
        Builder jobs(Consumer<Job.Builder>... jobs);

        /**
         * <p>
         * A value that you use to access the second and subsequent pages of results, if any. When the jobs in the
         * specified pipeline fit on one page or when you've reached the last page of results, the value of
         * <code>NextPageToken</code> is <code>null</code>.
         * </p>
         * 
         * @param nextPageToken
         *        A value that you use to access the second and subsequent pages of results, if any. When the jobs in
         *        the specified pipeline fit on one page or when you've reached the last page of results, the value of
         *        <code>NextPageToken</code> is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsByPipelineResponse model) {
            super(model);
            jobs(model.jobs);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Job.Builder> getJobs() {
            if (jobs instanceof SdkAutoConstructList) {
                return null;
            }
            return jobs != null ? jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> Job.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobsCopier.copyFromBuilder(jobs);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListJobsByPipelineResponse build() {
            return new ListJobsByPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
