/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Permission</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permission implements SdkPojo, Serializable, ToCopyableBuilder<Permission.Builder, Permission> {
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::granteeType)).setter(setter(Builder::granteeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType").build()).build();

    private static final SdkField<String> GRANTEE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::grantee)).setter(setter(Builder::grantee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").build()).build();

    private static final SdkField<List<String>> ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Permission::access))
            .setter(setter(Builder::access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_TYPE_FIELD,
            GRANTEE_FIELD, ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String granteeType;

    private final String grantee;

    private final List<String> access;

    private Permission(BuilderImpl builder) {
        this.granteeType = builder.granteeType;
        this.grantee = builder.grantee;
        this.access = builder.access;
    }

    /**
     * <p>
     * The type of value that appears in the Grantee object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
     * Amazon CloudFront distribution.
     * </p>
     * <important>
     * <p>
     * A canonical user ID is not the same as an AWS account number.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>Email</code>: The registered email address of an AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of value that appears in the Grantee object:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for
     *         an Amazon CloudFront distribution.
     *         </p>
     *         <important>
     *         <p>
     *         A canonical user ID is not the same as an AWS account number.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>Email</code>: The registered email address of an AWS account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     *         <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     *         </p>
     *         </li>
     */
    public String granteeType() {
        return granteeType;
    }

    /**
     * <p>
     * The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or
     * group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront
     * distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     * </p>
     * 
     * @return The AWS user or group that you want to have access to transcoded files and playlists. To identify the
     *         user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a
     *         CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     */
    public String grantee() {
        return grantee;
    }

    /**
     * Returns true if the Access property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAccess() {
        return access != null && !(access instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds
     * to the Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
     * Elastic Transcoder adds to the Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccess()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic
     *         Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails
     *         that Elastic Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     */
    public List<String> access() {
        return access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(granteeType());
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        hashCode = 31 * hashCode + Objects.hashCode(access());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        return Objects.equals(granteeType(), other.granteeType()) && Objects.equals(grantee(), other.grantee())
                && Objects.equals(access(), other.access());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Permission").add("GranteeType", granteeType()).add("Grantee", grantee()).add("Access", access())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GranteeType":
            return Optional.ofNullable(clazz.cast(granteeType()));
        case "Grantee":
            return Optional.ofNullable(clazz.cast(grantee()));
        case "Access":
            return Optional.ofNullable(clazz.cast(access()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * The type of value that appears in the Grantee object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
         * Amazon CloudFront distribution.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>Email</code>: The registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param granteeType
         *        The type of value that appears in the Grantee object:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity
         *        for an Amazon CloudFront distribution.
         *        </p>
         *        <important>
         *        <p>
         *        A canonical user ID is not the same as an AWS account number.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>Email</code>: The registered email address of an AWS account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         *        <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeType(String granteeType);

        /**
         * <p>
         * The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or
         * group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront
         * distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
         * </p>
         * 
         * @param grantee
         *        The AWS user or group that you want to have access to transcoded files and playlists. To identify the
         *        user or group, you can specify the canonical user ID for an AWS account, an origin access identity for
         *        a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(String grantee);

        /**
         * <p>
         * The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder
         * adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
         * Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param access
         *        The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic
         *        Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the
         *        thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder access(Collection<String> access);

        /**
         * <p>
         * The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder
         * adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
         * Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param access
         *        The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic
         *        Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the
         *        thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder access(String... access);
    }

    static final class BuilderImpl implements Builder {
        private String granteeType;

        private String grantee;

        private List<String> access = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            granteeType(model.granteeType);
            grantee(model.grantee);
            access(model.access);
        }

        public final String getGranteeType() {
            return granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        public final String getGrantee() {
            return grantee;
        }

        @Override
        public final Builder grantee(String grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(String grantee) {
            this.grantee = grantee;
        }

        public final Collection<String> getAccess() {
            return access;
        }

        @Override
        public final Builder access(Collection<String> access) {
            this.access = AccessControlsCopier.copy(access);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(String... access) {
            access(Arrays.asList(access));
            return this;
        }

        public final void setAccess(Collection<String> access) {
            this.access = AccessControlsCopier.copy(access);
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
