/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeElasticsearchDomainRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, UpgradeElasticsearchDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeElasticsearchDomainRequest.getter(UpgradeElasticsearchDomainRequest::domainName)).setter(UpgradeElasticsearchDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeElasticsearchDomainRequest.getter(UpgradeElasticsearchDomainRequest::targetVersion)).setter(UpgradeElasticsearchDomainRequest.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpgradeElasticsearchDomainRequest.getter(UpgradeElasticsearchDomainRequest::performCheckOnly)).setter(UpgradeElasticsearchDomainRequest.setter(Builder::performCheckOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD));
    private final String domainName;
    private final String targetVersion;
    private final Boolean performCheckOnly;

    private UpgradeElasticsearchDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
    }

    public String domainName() {
        return this.domainName;
    }

    public String targetVersion() {
        return this.targetVersion;
    }

    public Boolean performCheckOnly() {
        return this.performCheckOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performCheckOnly());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeElasticsearchDomainRequest)) {
            return false;
        }
        UpgradeElasticsearchDomainRequest other = (UpgradeElasticsearchDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.performCheckOnly(), other.performCheckOnly());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeElasticsearchDomainRequest").add("DomainName", (Object)this.domainName()).add("TargetVersion", (Object)this.targetVersion()).add("PerformCheckOnly", (Object)this.performCheckOnly()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "PerformCheckOnly": {
                return Optional.ofNullable(clazz.cast(this.performCheckOnly()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeElasticsearchDomainRequest, T> g) {
        return obj -> g.apply((UpgradeElasticsearchDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String targetVersion;
        private Boolean performCheckOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeElasticsearchDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.targetVersion(model.targetVersion);
            this.performCheckOnly(model.performCheckOnly);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Boolean getPerformCheckOnly() {
            return this.performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeElasticsearchDomainRequest build() {
            return new UpgradeElasticsearchDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeElasticsearchDomainRequest> {
        public Builder domainName(String var1);

        public Builder targetVersion(String var1);

        public Builder performCheckOnly(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

