/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStepsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpgradeHistory> {
    private static final SdkField<String> UPGRADE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeHistory.getter(UpgradeHistory::upgradeName)).setter(UpgradeHistory.setter(Builder::upgradeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeName").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpgradeHistory.getter(UpgradeHistory::startTimestamp)).setter(UpgradeHistory.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<String> UPGRADE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeHistory.getter(UpgradeHistory::upgradeStatusAsString)).setter(UpgradeHistory.setter(Builder::upgradeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStatus").build()}).build();
    private static final SdkField<List<UpgradeStepItem>> STEPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpgradeHistory.getter(UpgradeHistory::stepsList)).setter(UpgradeHistory.setter(Builder::stepsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeStepItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_NAME_FIELD, START_TIMESTAMP_FIELD, UPGRADE_STATUS_FIELD, STEPS_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String upgradeName;
    private final Instant startTimestamp;
    private final String upgradeStatus;
    private final List<UpgradeStepItem> stepsList;

    private UpgradeHistory(BuilderImpl builder) {
        this.upgradeName = builder.upgradeName;
        this.startTimestamp = builder.startTimestamp;
        this.upgradeStatus = builder.upgradeStatus;
        this.stepsList = builder.stepsList;
    }

    public String upgradeName() {
        return this.upgradeName;
    }

    public Instant startTimestamp() {
        return this.startTimestamp;
    }

    public UpgradeStatus upgradeStatus() {
        return UpgradeStatus.fromValue(this.upgradeStatus);
    }

    public String upgradeStatusAsString() {
        return this.upgradeStatus;
    }

    public List<UpgradeStepItem> stepsList() {
        return this.stepsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeHistory)) {
            return false;
        }
        UpgradeHistory other = (UpgradeHistory)obj;
        return Objects.equals(this.upgradeName(), other.upgradeName()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.upgradeStatusAsString(), other.upgradeStatusAsString()) && Objects.equals(this.stepsList(), other.stepsList());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeHistory").add("UpgradeName", (Object)this.upgradeName()).add("StartTimestamp", (Object)this.startTimestamp()).add("UpgradeStatus", (Object)this.upgradeStatusAsString()).add("StepsList", this.stepsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeName": {
                return Optional.ofNullable(clazz.cast(this.upgradeName()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "UpgradeStatus": {
                return Optional.ofNullable(clazz.cast(this.upgradeStatusAsString()));
            }
            case "StepsList": {
                return Optional.ofNullable(clazz.cast(this.stepsList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeHistory, T> g) {
        return obj -> g.apply((UpgradeHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String upgradeName;
        private Instant startTimestamp;
        private String upgradeStatus;
        private List<UpgradeStepItem> stepsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeHistory model) {
            this.upgradeName(model.upgradeName);
            this.startTimestamp(model.startTimestamp);
            this.upgradeStatus(model.upgradeStatus);
            this.stepsList(model.stepsList);
        }

        public final String getUpgradeName() {
            return this.upgradeName;
        }

        @Override
        public final Builder upgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
            return this;
        }

        public final void setUpgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final String getUpgradeStatusAsString() {
            return this.upgradeStatus;
        }

        @Override
        public final Builder upgradeStatus(String upgradeStatus) {
            this.upgradeStatus = upgradeStatus;
            return this;
        }

        @Override
        public final Builder upgradeStatus(UpgradeStatus upgradeStatus) {
            this.upgradeStatus(upgradeStatus.toString());
            return this;
        }

        public final void setUpgradeStatus(String upgradeStatus) {
            this.upgradeStatus = upgradeStatus;
        }

        public final Collection<UpgradeStepItem.Builder> getStepsList() {
            return this.stepsList != null ? (Collection)this.stepsList.stream().map(UpgradeStepItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepsList(Collection<UpgradeStepItem> stepsList) {
            this.stepsList = UpgradeStepsListCopier.copy(stepsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepsList(UpgradeStepItem ... stepsList) {
            this.stepsList(Arrays.asList(stepsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepsList(Consumer<UpgradeStepItem.Builder> ... stepsList) {
            this.stepsList(Stream.of(stepsList).map(c -> (UpgradeStepItem)((UpgradeStepItem.Builder)UpgradeStepItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepsList(Collection<UpgradeStepItem.BuilderImpl> stepsList) {
            this.stepsList = UpgradeStepsListCopier.copyFromBuilder(stepsList);
        }

        public UpgradeHistory build() {
            return new UpgradeHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpgradeHistory> {
        public Builder upgradeName(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder upgradeStatus(String var1);

        public Builder upgradeStatus(UpgradeStatus var1);

        public Builder stepsList(Collection<UpgradeStepItem> var1);

        public Builder stepsList(UpgradeStepItem ... var1);

        public Builder stepsList(Consumer<UpgradeStepItem.Builder> ... var1);
    }
}

